package org.crazycake.jdbcTemplateTool.impl;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;

import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

/**
 * 返回主键的PreparedStatementCreator
 * @author Administrator
 *
 */
public class ReturnIdPreparedStatementCreator implements PreparedStatementCreator {

	private String sql;
	private Object[] params;
	private String autoGeneratedColumnName;

	public ReturnIdPreparedStatementCreator(String sql,Object[] params, String autoGeneratedColumnName){
		this.sql = sql;
		this.params = params;
		this.autoGeneratedColumnName = autoGeneratedColumnName;
	}
	
	@Override
	public PreparedStatement createPreparedStatement(Connection connection)
			throws SQLException {
		PreparedStatement ps = connection.prepareStatement(sql, new String[] {autoGeneratedColumnName});
        for (int i = 0; i < params.length; i++) {
			Object value = params[i];
			ps.setObject((i+1), value);
		}
        return ps;
	}

}
