/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.starter.motan.config;

import com.sinosoft.starter.motan.config.MotanAnnotationPackageConfiguration;
import com.sinosoft.starter.motan.log.SinoLogService;
import com.sinosoft.starter.motan.properties.MotanProperties;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.config.springsupport.ProtocolConfigBean;
import com.weibo.api.motan.config.springsupport.RegistryConfigBean;
import com.weibo.api.motan.log.LogService;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={MotanProperties.class})
@ImportAutoConfiguration(value={MotanAnnotationPackageConfiguration.class})
@Configuration
public class MotanCommonConfiguration {
    @Autowired
    private MotanProperties motanProperties;

    public MotanCommonConfiguration(MotanProperties motanProperties) {
        this.motanProperties = motanProperties;
    }

    @Bean(name={"motan"})
    public ProtocolConfigBean protocolConfig() {
        Integer maxWorkerThread = this.motanProperties.getWorkerThread().getMax();
        Integer minWorkerThread = this.motanProperties.getWorkerThread().getMin();
        Integer maxContentLength = this.motanProperties.getMaxContentLength();
        ProtocolConfigBean config = new ProtocolConfigBean();
        config.setDefault(true);
        config.setSerialization("hessian2Extension");
        config.setName("motan");
        config.setMaxContentLength(Integer.valueOf(maxContentLength == null ? 0xA00000 : maxContentLength));
        config.setMaxWorkerThread(Integer.valueOf(maxWorkerThread == null ? 200 : maxWorkerThread));
        config.setMinWorkerThread(Integer.valueOf(minWorkerThread == null ? 20 : minWorkerThread));
        ConcurrentHashMap<String, String> parameters = new ConcurrentHashMap<String, String>();
        parameters.put(URLParamType.endpointFactory.getName(), "eleganceMotan");
        config.setParameters(parameters);
        return config;
    }

    @Bean(name={"registry"})
    public RegistryConfigBean registryConfig() {
        String zookeeperAddress = this.motanProperties.getRegistryCenter().getAddress();
        String regProtocol = this.motanProperties.getRegistryCenter().getRegProtocol();
        Integer connectTimeout = this.motanProperties.getRegistryCenter().getConnectTimeout();
        RegistryConfigBean config = new RegistryConfigBean();
        config.setDefault(true);
        config.setRegProtocol(regProtocol == null ? "commondZookeeper" : regProtocol);
        if (zookeeperAddress == null) {
            throw new RuntimeException("\u8bf7\u914d\u7f6ezookeeper\u5730\u5740");
        }
        config.setAddress(zookeeperAddress);
        config.setConnectTimeout(Integer.valueOf(connectTimeout == null ? 30000 : connectTimeout));
        return config;
    }

    @Bean
    SinoLogService sinoLogService() {
        Boolean logEnable = this.motanProperties.getLog().getEnable();
        SinoLogService sinoLogService = new SinoLogService(logEnable);
        LoggerUtil.setLogService((LogService)sinoLogService);
        return sinoLogService;
    }
}

