/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.shiro.jwt.config;

import com.alibaba.fastjson.JSON;
import com.sinosoftgz.starter.jwt.properties.JwtProperties;
import com.sinosoftgz.starter.jwt.utils.JwtUtils;
import com.sinosoftgz.starter.shiro.jwt.biz.UserAuthBiz;
import com.sinosoftgz.starter.shiro.jwt.filter.ShiroJwtAccessControlFilter;
import com.sinosoftgz.starter.shiro.jwt.interceptor.TokenRefreshInterceptor;
import com.sinosoftgz.starter.shiro.jwt.support.ShiroJwtRealm;
import com.sinosoftgz.starter.shiro.properties.ShiroProperties;
import com.sinosoftgz.starter.shiro.support.CustomDefaultSubjectFactory;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.Filter;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableConfigurationProperties(value={ShiroProperties.class, JwtProperties.class})
@ConditionalOnProperty(prefix="spring.jwt", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ShiroJwtConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ShiroJwtConfiguration.class);
    private static final String DEFAULT_URL = "/**";
    private static final String ANON = "anon";
    private static final String SHIRO_JWT_AUTHC = "shiroJwtAuthc";
    private static final String SHIRO_JWT_FILTER_FACTORY_NAME = "shiroJwtFilterFactoryBean";
    private JwtProperties jwtProperties;
    private ShiroProperties shiroProperties;

    public ShiroJwtConfiguration(JwtProperties jwtProperties, ShiroProperties shiroProperties) {
        this.jwtProperties = jwtProperties;
        this.shiroProperties = shiroProperties;
    }

    @Bean
    public ShiroJwtRealm shiroJwtRealm() {
        ShiroJwtRealm realm = new ShiroJwtRealm();
        realm.setCachingEnabled(false);
        return realm;
    }

    @Bean
    public CustomDefaultSubjectFactory subjectFactory() {
        return new CustomDefaultSubjectFactory(this.shiroProperties);
    }

    @Bean
    public SessionManager sessionManager() {
        DefaultSessionManager sessionManager = new DefaultSessionManager();
        sessionManager.setSessionValidationSchedulerEnabled(false);
        return sessionManager;
    }

    @Bean
    public SessionStorageEvaluator sessionStorageEvaluator() {
        DefaultSessionStorageEvaluator defaultSessionStorageEvaluator = new DefaultSessionStorageEvaluator();
        defaultSessionStorageEvaluator.setSessionStorageEnabled(false);
        return defaultSessionStorageEvaluator;
    }

    @Bean
    public SecurityManager securityManager(ShiroJwtRealm shiroJwtRealm, SessionStorageEvaluator sessionStorageEvaluator, SubjectFactory subjectFactory, SessionManager sessionManager) {
        DefaultWebSecurityManager defaultSecurityManager = new DefaultWebSecurityManager();
        defaultSecurityManager.setRealm((Realm)shiroJwtRealm);
        DefaultSubjectDAO defaultSubjectDAO = new DefaultSubjectDAO();
        defaultSubjectDAO.setSessionStorageEvaluator(sessionStorageEvaluator);
        defaultSecurityManager.setSubjectDAO((SubjectDAO)defaultSubjectDAO);
        defaultSecurityManager.setSubjectFactory(subjectFactory);
        defaultSecurityManager.setSessionManager(sessionManager);
        return defaultSecurityManager;
    }

    @Bean
    public ShiroJwtAccessControlFilter shiroJwtAccessControlFilter() {
        ShiroJwtAccessControlFilter shiroJwtAccessControlFilter = new ShiroJwtAccessControlFilter(this.jwtProperties);
        return shiroJwtAccessControlFilter;
    }

    @Bean
    public FilterRegistrationBean registration(ShiroJwtAccessControlFilter shiroJwtAccessControlFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)shiroJwtAccessControlFilter, new ServletRegistrationBean[0]);
        registration.setEnabled(false);
        return registration;
    }

    @Bean(name={"shiroJwtFilterFactoryBean"})
    public ShiroFilterFactoryBean shiroFilterFactoryBean(SecurityManager securityManager, ShiroJwtAccessControlFilter shiroJwtAccessControlFilter) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        LinkedHashMap<String, ShiroJwtAccessControlFilter> filters = new LinkedHashMap<String, ShiroJwtAccessControlFilter>();
        filters.put(SHIRO_JWT_AUTHC, shiroJwtAccessControlFilter);
        shiroFilterFactoryBean.setFilters(filters);
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        List urlExcludes = this.shiroProperties.getUrlExcludes();
        if (!CollectionUtils.isEmpty((Collection)urlExcludes)) {
            log.info("Shiro URL Excludes : {}", (Object)JSON.toJSONString((Object)urlExcludes));
            for (String urlExclude : urlExcludes) {
                filterChainDefinitionMap.put(urlExclude, ANON);
            }
        } else {
            log.info("Shiro URL Excludes Is Empty .");
        }
        List urlPatterns = this.shiroProperties.getUrlPatterns();
        if (CollectionUtils.isEmpty((Collection)urlPatterns)) {
            log.warn("Shiro urlPatterns is empty,set default /**");
            filterChainDefinitionMap.put(DEFAULT_URL, SHIRO_JWT_AUTHC);
        } else {
            for (String urlPattern : urlPatterns) {
                filterChainDefinitionMap.put(urlPattern, SHIRO_JWT_AUTHC);
            }
        }
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
        return shiroFilterFactoryBean;
    }

    @Bean
    public FilterRegistrationBean delegatingFilterProxy() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        DelegatingFilterProxy proxy = new DelegatingFilterProxy();
        proxy.setTargetFilterLifecycle(true);
        proxy.setTargetBeanName(SHIRO_JWT_FILTER_FACTORY_NAME);
        filterRegistrationBean.setFilter((Filter)proxy);
        return filterRegistrationBean;
    }

    @Bean
    public DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        advisorAutoProxyCreator.setProxyTargetClass(true);
        return advisorAutoProxyCreator;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager(securityManager);
        return authorizationAttributeSourceAdvisor;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.jwt", name={"enable-auto-refresh-token"}, havingValue="true", matchIfMissing=false)
    public TokenRefreshInterceptor tokenRefreshInterceptor(JwtProperties jwtProperties, UserAuthBiz userAuthBiz, JwtUtils jwtUtils) {
        return new TokenRefreshInterceptor(jwtProperties, userAuthBiz, jwtUtils);
    }

    @Configuration
    @ConditionalOnProperty(prefix="spring.jwt", name={"enable-auto-refresh-token"}, havingValue="true", matchIfMissing=false)
    public static class ShiroJwtWebMvcConfigurer
    extends WebMvcConfigurerAdapter {
        @Autowired
        private TokenRefreshInterceptor tokenRefreshInterceptor;
        @Autowired
        private JwtProperties prop;

        public void addInterceptors(InterceptorRegistry registry) {
            InterceptorRegistration reg = registry.addInterceptor((HandlerInterceptor)this.tokenRefreshInterceptor);
            List patterns = this.prop.getUrlPatterns();
            log.info("\u542f\u7528token\u81ea\u52a8\u5237\u65b0\u673a\u5236\uff0c\u5df2\u6ce8\u518cTokenRefreshInterceptor");
            for (String urlPattern : patterns) {
                log.info("TokenRefreshInterceptor\u5339\u914dURL\u89c4\u5219\uff1a" + urlPattern);
                reg.addPathPatterns(new String[]{urlPattern});
            }
        }

        public void addCorsMappings(CorsRegistry registry) {
            List urls = this.prop.getUrlPatterns();
            for (String url : urls) {
                registry.addMapping(url).exposedHeaders(new String[]{this.prop.getHeaderKeyOfToken()});
            }
        }
    }
}

