/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.shiro.jwt.filter;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.sinosoftgz.starter.jwt.properties.JwtProperties;
import com.sinosoftgz.starter.shiro.biz.ShiroUserBiz;
import com.sinosoftgz.starter.shiro.jwt.support.JWTToken;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ShiroJwtAccessControlFilter
extends AccessControlFilter {
    private static final Logger logger = LoggerFactory.getLogger(ShiroJwtAccessControlFilter.class);
    @Autowired
    ShiroUserBiz shiroUserBiz;
    private JwtProperties jwtProperties;

    public ShiroJwtAccessControlFilter(JwtProperties jwtProperties) {
        this.jwtProperties = jwtProperties;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        HttpServletRequest req = (HttpServletRequest)request;
        String authorization = req.getHeader(this.jwtProperties.getHeaderKeyOfToken());
        if (Strings.isNullOrEmpty((String)authorization)) {
            authorization = req.getParameter(this.jwtProperties.getHeaderKeyOfToken());
        }
        JWTToken token = new JWTToken(authorization);
        try {
            this.getSubject(request, response).login((AuthenticationToken)token);
        }
        catch (Exception e) {
            logger.error("\u8ba4\u8bc1\u5931\u8d25:" + e.getMessage());
            this.returnLoginError(response);
            return false;
        }
        return true;
    }

    protected boolean onAccessDenied(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        return false;
    }

    public void returnLoginError(ServletResponse response) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter writer = response.getWriter();
        writer.write(JSON.toJSONString((Object)this.shiroUserBiz.onAuthenticationFailed()));
    }
}

