/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.shiro.jwt.interceptor;

import com.sinosoftgz.starter.jwt.model.JwtPrincipal;
import com.sinosoftgz.starter.jwt.properties.JwtProperties;
import com.sinosoftgz.starter.jwt.utils.JwtUtils;
import com.sinosoftgz.starter.shiro.jwt.biz.UserAuthBiz;
import com.sinosoftgz.starter.shiro.jwt.model.UserInfo;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class TokenRefreshInterceptor
implements HandlerInterceptor {
    private JwtProperties jwtProperties;
    private UserAuthBiz userAuthBiz;
    private JwtUtils jwtUtils;

    public TokenRefreshInterceptor(JwtProperties jwtProperties, UserAuthBiz userAuthBiz, JwtUtils jwtUtils) {
        this.jwtProperties = jwtProperties;
        this.userAuthBiz = userAuthBiz;
        this.jwtUtils = jwtUtils;
    }

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) throws Exception {
        Subject subject = SecurityUtils.getSubject();
        JwtPrincipal principal = (JwtPrincipal)subject.getPrincipal();
        if (principal != null && System.currentTimeMillis() > principal.getExpiresAt()) {
            UserInfo user = this.userAuthBiz.getUserInfo(principal.getAccount());
            String newToken = this.jwtUtils.sign(user.getAccount(), user.getSecret());
            httpServletResponse.setHeader(this.jwtProperties.getHeaderKeyOfToken(), newToken);
        }
        return true;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
    }
}

