/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.shiro.jwt.support;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.sinosoftgz.starter.jwt.model.JwtPrincipal;
import com.sinosoftgz.starter.jwt.utils.JwtUtils;
import com.sinosoftgz.starter.shiro.jwt.biz.UserAuthBiz;
import com.sinosoftgz.starter.shiro.jwt.model.UserInfo;
import com.sinosoftgz.starter.shiro.jwt.support.JWTToken;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ShiroJwtRealm
extends AuthorizingRealm {
    private static final Logger logger = LoggerFactory.getLogger(ShiroJwtRealm.class);
    @Autowired
    JwtUtils jwtUtils;
    @Autowired
    UserAuthBiz userAuthBiz;

    public boolean supports(AuthenticationToken token) {
        return token instanceof JWTToken;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        Set<String> roles;
        JwtPrincipal principal = (JwtPrincipal)principalCollection.getPrimaryPrincipal();
        UserInfo account = this.userAuthBiz.getUserInfo(principal.getAccount());
        if (StringUtils.isEmpty((Object)account)) {
            throw new RuntimeException("\u83b7\u53d6\u7528\u6237\u6388\u6743\u4fe1\u606f\u5931\u8d25");
        }
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        Set<String> permissions = account.getPermissions();
        if (permissions != null && !permissions.isEmpty()) {
            info.addStringPermissions(permissions);
        }
        if ((roles = account.getRoles()) != null) {
            info.addRoles(roles);
        }
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        String token = (String)authenticationToken.getCredentials();
        String username = this.jwtUtils.getAccount(token);
        if (username == null) {
            throw new AuthenticationException("\u65e0\u6548\u7684\u8bf7\u6c42");
        }
        UserInfo user = this.userAuthBiz.getUserInfo(username);
        if (user == null) {
            throw new AuthenticationException("\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f");
        }
        DecodedJWT jwt = this.jwtUtils.checkToken(token, user.getSecret());
        if (jwt == null) {
            throw new AuthenticationException("token\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        JwtPrincipal principal = new JwtPrincipal();
        principal.setAccount(user.getAccount());
        principal.setExpiresAt(jwt.getExpiresAt().getTime());
        return new SimpleAuthenticationInfo((Object)principal, (Object)token, this.getName());
    }
}

