/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.simpleSession;

import com.sinosoftgz.simpleSession.SessionHttpServletRequestWrapper;
import com.sinosoftgz.simpleSession.data.SessionCacheManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;

public class SessionSharingFilter
implements Filter {
    private static final int MAX_ACTIVE_TIME = 1800;
    private static final String MAX_ACTIVE_TIME_KEY = "maxActiveTime";
    private ServletContext servletContext;
    private int maxActiveTime = 1800;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        String matString = filterConfig.getInitParameter(MAX_ACTIVE_TIME_KEY);
        if (StringUtils.isNotEmpty((CharSequence)matString)) {
            this.maxActiveTime = Integer.valueOf(matString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse HttpServletResponse2 = (HttpServletResponse)response;
        SessionHttpServletRequestWrapper sessionHttpServletRequestWrapper = new SessionHttpServletRequestWrapper(httpServletRequest, this.maxActiveTime, this.servletContext);
        try {
            chain.doFilter((ServletRequest)sessionHttpServletRequestWrapper, (ServletResponse)HttpServletResponse2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (sessionHttpServletRequestWrapper.isRequestedSessionIdValid()) {
                Cookie cookie = new Cookie("JSESSIONID", null);
                cookie.setMaxAge(0);
                HttpServletResponse2.addCookie(cookie);
                HttpSession httpSession = sessionHttpServletRequestWrapper.getSession(false);
                if (httpSession != null) {
                    SessionCacheManager.getSessionCache().put(httpSession.getId(), null, 0);
                }
            }
        }
    }

    public void destroy() {
    }
}

