/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.data;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    public static String[][] getData(File file) throws FileNotFoundException, IOException {
        return ExcelUtils.getData(file, 1);
    }

    public static String[][] getData(File file, int ignoreRows) throws FileNotFoundException, IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        return ExcelUtils.getData(in, ignoreRows, 1);
    }

    public static String[][] getData(InputStream inputStream, int ignoreRows) throws FileNotFoundException, IOException {
        return ExcelUtils.getData(inputStream, ignoreRows, 1);
    }

    public static String[][] getData(InputStream inputStream, int ignoreRows, int index) throws FileNotFoundException, IOException {
        String[][] data;
        try {
            data = ExcelUtils.getDataXssf(inputStream, ignoreRows, index);
        }
        catch (NotOfficeXmlFileException noxfe) {
            data = ExcelUtils.getDataHssf(inputStream, ignoreRows, index);
        }
        return data;
    }

    public static String[][] getDataHssf(InputStream inputStream, int ignoreRows, int index) throws FileNotFoundException, IOException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        int rowSize = 0;
        POIFSFileSystem fs = new POIFSFileSystem(inputStream);
        HSSFWorkbook wb = null;
        wb = new HSSFWorkbook(fs);
        HSSFCell cell = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DecimalFormat decimalFormat = new DecimalFormat("0");
        StringBuilder value = new StringBuilder();
        HSSFSheet st = wb.getSheetAt(index - 1);
        for (int rowIndex = ignoreRows; rowIndex <= st.getLastRowNum(); ++rowIndex) {
            HSSFRow row = st.getRow(rowIndex);
            if (row == null) continue;
            int tempRowSize = row.getLastCellNum() + 1;
            if (tempRowSize > rowSize) {
                rowSize = tempRowSize;
            }
            Object[] values = new String[rowSize];
            Arrays.fill(values, "");
            boolean hasValue = false;
            for (short columnIndex = 0; columnIndex <= row.getLastCellNum(); columnIndex = (short)(columnIndex + 1)) {
                value.setLength(0);
                cell = row.getCell((int)columnIndex);
                if (cell != null) {
                    switch (cell.getCellType()) {
                        case STRING: {
                            value.append(cell.getStringCellValue());
                            break;
                        }
                        case NUMERIC: {
                            if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                Date date = cell.getDateCellValue();
                                if (date == null) break;
                                value.append(dateFormat.format(date));
                                break;
                            }
                            value.append(decimalFormat.format(cell.getNumericCellValue()));
                            break;
                        }
                        case FORMULA: {
                            if (cell.getStringCellValue().equals("")) {
                                value.append(cell.getNumericCellValue());
                                break;
                            }
                            value.append(cell.getStringCellValue());
                            break;
                        }
                        case BLANK: {
                            break;
                        }
                        case ERROR: {
                            break;
                        }
                        case BOOLEAN: {
                            value.append(cell.getBooleanCellValue() ? "Y" : "N");
                            break;
                        }
                        default: {
                            value.setLength(0);
                        }
                    }
                }
                String s = value.toString().trim();
                if (columnIndex == 0 && s.equals("") && row.getCell((int)new Short("1").shortValue()) == null && row.getCell((int)new Short("2").shortValue()) == null && row.getCell((int)new Short("3").shortValue()) == null && row.getCell((int)new Short("4").shortValue()) == null && row.getCell((int)new Short("5").shortValue()) == null) break;
                values[columnIndex] = value.toString();
                hasValue = true;
                if (columnIndex != 4 || !"".equals(values[0]) || !"".equals(values[1]) || !"".equals(values[2]) || !"".equals(values[3]) || !"".equals(values[4])) continue;
                hasValue = false;
                break;
            }
            if (!hasValue) continue;
            result.add(values);
        }
        inputStream.close();
        String[][] returnArray = new String[result.size()][rowSize];
        for (int i = 0; i < returnArray.length; ++i) {
            returnArray[i] = (String[])result.get(i);
        }
        return returnArray;
    }

    public static String[][] getDataXssf(InputStream inputStream, int ignoreRows, int index) throws FileNotFoundException, IOException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        int rowSize = 0;
        XSSFWorkbook wb = null;
        wb = new XSSFWorkbook(inputStream);
        XSSFCell cell = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DecimalFormat decimalFormat = new DecimalFormat("0");
        StringBuilder value = new StringBuilder();
        XSSFSheet st = wb.getSheetAt(index - 1);
        for (int rowIndex = ignoreRows; rowIndex <= st.getLastRowNum(); ++rowIndex) {
            XSSFRow row = st.getRow(rowIndex);
            if (row == null) continue;
            int tempRowSize = row.getLastCellNum() + 1;
            if (tempRowSize > rowSize) {
                rowSize = tempRowSize;
            }
            Object[] values = new String[rowSize];
            Arrays.fill(values, "");
            boolean hasValue = false;
            for (short columnIndex = 0; columnIndex <= row.getLastCellNum(); columnIndex = (short)(columnIndex + 1)) {
                value.setLength(0);
                cell = row.getCell((int)columnIndex);
                if (cell != null) {
                    switch (cell.getCellType()) {
                        case STRING: {
                            value.append(cell.getStringCellValue());
                            break;
                        }
                        case NUMERIC: {
                            if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                Date date = cell.getDateCellValue();
                                if (date == null) break;
                                value.append(dateFormat.format(date));
                                break;
                            }
                            value.append(decimalFormat.format(cell.getNumericCellValue()));
                            break;
                        }
                        case FORMULA: {
                            if (cell.getStringCellValue().equals("")) {
                                value.append(cell.getNumericCellValue());
                                break;
                            }
                            value.append(cell.getStringCellValue());
                            break;
                        }
                        case BLANK: {
                            break;
                        }
                        case ERROR: {
                            break;
                        }
                        case BOOLEAN: {
                            value.append(cell.getBooleanCellValue() ? "Y" : "N");
                            break;
                        }
                        default: {
                            value.setLength(0);
                        }
                    }
                }
                String s = value.toString().trim();
                if (columnIndex == 0 && s.equals("") && row.getCell((int)new Short("1").shortValue()) == null && row.getCell((int)new Short("2").shortValue()) == null && row.getCell((int)new Short("3").shortValue()) == null && row.getCell((int)new Short("4").shortValue()) == null && row.getCell((int)new Short("5").shortValue()) == null) break;
                values[columnIndex] = value.toString();
                hasValue = true;
                if (columnIndex != 4 || !"".equals(values[0]) || !"".equals(values[1]) || !"".equals(values[2]) || !"".equals(values[3]) || !"".equals(values[4])) continue;
                hasValue = false;
                break;
            }
            if (!hasValue) continue;
            result.add(values);
        }
        inputStream.close();
        String[][] returnArray = new String[result.size()][rowSize];
        for (int i = 0; i < returnArray.length; ++i) {
            returnArray[i] = (String[])result.get(i);
        }
        return returnArray;
    }

    public static String[][] getData(File file, int ignoreRows, int index) throws FileNotFoundException, IOException {
        ArrayList result = new ArrayList();
        boolean rowSize = false;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        return ExcelUtils.getData(in, ignoreRows, index);
    }
}

