/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.encrypt;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sinosoftgz.utils.data.StandardCharset;
import sinosoftgz.utils.encrypt.EncryptHandler;
import sinosoftgz.utils.encrypt.impl.MD5EncryptHandler;
import sinosoftgz.utils.encrypt.impl.SHA1EncryptHandler;
import sinosoftgz.utils.encrypt.impl.SHA256EncryptHandler;

public class EncryptUtil {
    private static Map<Type, EncryptHandler> handlerMap = new ConcurrentHashMap<Type, EncryptHandler>();

    public static String encrypt(String src, String salt, Type type) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        EncryptHandler handler = handlerMap.get((Object)type);
        if (handler == null) {
            switch (type) {
                case MD5: {
                    handler = new MD5EncryptHandler();
                    break;
                }
                case SHA1: {
                    handler = new SHA1EncryptHandler();
                    break;
                }
                case SHA256: {
                    handler = new SHA256EncryptHandler();
                    break;
                }
                default: {
                    return src;
                }
            }
            handlerMap.put(type, handler);
        }
        return handler.encrypt(src, salt == null ? "" : salt, StandardCharset.UTF_8);
    }

    public static enum Type {
        MD5,
        SHA1,
        SHA256;


        public static Type fromName(String name) {
            switch (name) {
                case "SHA-1": {
                    return SHA1;
                }
                case "SHA-256": {
                    return SHA256;
                }
                case "MD5": {
                    return MD5;
                }
            }
            return null;
        }
    }
}

