/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sinosoftgz.utils.http.entity.HttpRequest;

public interface HttpClientService {
    public static final String URL_PLACEHOLDER_START = "{";
    public static final String URL_PLACEHOLDER_END = "}";
    public static final String ARRAY_IDX_START = "[";
    public static final String ARRAY_IDX_END = "]";
    public static final Pattern urlParamPattern = Pattern.compile(String.format("\\%s(.*?)\\%s", "{", "}"));
    public static final Pattern arrayIdxPattern = Pattern.compile(String.format("^.*?\\%s(\\d+)\\%s$", "[", "]"));

    public byte[] doGet(HttpRequest var1) throws IOException;

    public byte[] doPost(HttpRequest var1);

    public byte[] doDelete(HttpRequest var1);

    public byte[] doPut(HttpRequest var1);

    default public byte[] get(HttpRequest httpRequest) throws IOException {
        String url = this.handleUrlParams(httpRequest.getUrl(), httpRequest.getParams());
        httpRequest.setUrl(url);
        return this.doGet(httpRequest);
    }

    default public byte[] post(HttpRequest httpRequest) {
        String url = this.handleUrlParams(httpRequest.getUrl(), httpRequest.getParams());
        httpRequest.setUrl(url);
        return this.doPost(httpRequest);
    }

    default public byte[] delete(HttpRequest httpRequest) {
        String url = this.handleUrlParams(httpRequest.getUrl(), httpRequest.getParams());
        httpRequest.setUrl(url);
        return this.doDelete(httpRequest);
    }

    default public byte[] put(HttpRequest httpRequest) {
        String url = this.handleUrlParams(httpRequest.getUrl(), httpRequest.getParams());
        httpRequest.setUrl(url);
        return this.doPut(httpRequest);
    }

    default public String handleUrlParams(String url, Map params) {
        if (params == null || params.isEmpty() || params.size() <= 0) {
            return url;
        }
        String newUrl = url;
        Matcher m = urlParamPattern.matcher(url);
        ArrayList<MachedUrlParam> machedUrlParamList = new ArrayList<MachedUrlParam>();
        while (m.find()) {
            machedUrlParamList.add(new MachedUrlParam(m.group(), m.start(), m.end()));
        }
        for (MachedUrlParam machedUrlParam : machedUrlParamList) {
            String paramName = machedUrlParam.getParamName();
            Object paramVal = params.get(paramName);
            newUrl.replace(String.format("%s%s%s", URL_PLACEHOLDER_START, paramName, URL_PLACEHOLDER_END), paramVal == null ? "" : paramVal.toString());
        }
        return newUrl;
    }

    public static class MachedUrlParam {
        private String paramName;
        private int start;
        private int end;

        public MachedUrlParam(String paramName, int start, int end) {
            this.paramName = paramName;
            this.start = start;
            this.end = end;
        }

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }
    }
}

