/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.http.okhttp;

import java.io.IOException;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import sinosoftgz.utils.http.HttpClientService;
import sinosoftgz.utils.http.entity.HttpRequest;

public class OkHttpClientService
implements HttpClientService {
    ThreadLocal<OkHttpClient> okHttpClientThreadLocal;

    protected OkHttpClient getOkHttpClient() {
        OkHttpClient okHttpClient;
        if (this.okHttpClientThreadLocal == null) {
            this.okHttpClientThreadLocal = new ThreadLocal();
            this.okHttpClientThreadLocal.set(null);
        }
        if ((okHttpClient = this.okHttpClientThreadLocal.get()) == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            okHttpClient = builder.build();
            this.okHttpClientThreadLocal.set(okHttpClient);
        }
        return okHttpClient;
    }

    @Override
    public byte[] doGet(HttpRequest httpRequest) throws IOException {
        Request request = new Request.Builder().url(httpRequest.getUrl()).get().build();
        Call call = this.getOkHttpClient().newCall(request);
        Response response = call.execute();
        return response.body().bytes();
    }

    @Override
    public byte[] doPost(HttpRequest httpRequest) {
        return null;
    }

    @Override
    public byte[] doDelete(HttpRequest httpRequest) {
        return null;
    }

    @Override
    public byte[] doPut(HttpRequest httpRequest) {
        return null;
    }
}

