package order.service.apiimpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import order.api.MallTempOrderApi;
import order.dto.MallAttachmentDto;
import order.dto.MallTempOrderDto;
import order.service.service.MallTempOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 */
@MotanService
public class MallTempOrderApiImpl implements MallTempOrderApi {

    @Autowired
    private MallTempOrderService mallOrderService;

    @Override
    public BaseResponse saveMallTempOrder(MallTempOrderDto mallTempOrderDto) {
        return mallOrderService.saveMallTempOrder(mallTempOrderDto);
    }

    @Override
    public BaseResponse deleteMallTempOrder(List<String> ids) {
        return mallOrderService.deleteMallTempOrder(ids);
    }

    @Override
    public BaseResponse deleteMallTempOrder(String memberId) {
        return mallOrderService.deleteMallTempOrder(memberId);
    }

    @Override
    public BaseResponse updateTempOrder(String addressId, String memberId, String errorInfo) {
        return mallOrderService.updateTempOrder(errorInfo,addressId,memberId);
    }

}
