package order.service.apiimpl.query;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import order.api.query.MallParentOrderQueryApi;
import order.dto.MallParentOrderDto;
import order.dto.MallParentSubOrderNosDto;
import order.dto.SimpleParentOrderDto;
import order.service.service.MallParentOrderService;
import order.service.service.query.MallParentOrderQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 */
@MotanService
public class MallParentOrderQueryApiImpl implements MallParentOrderQueryApi {

    @Autowired
    private MallParentOrderQueryService mallParentOrderQueryService;
    @Autowired
    private MallParentOrderService mallParentOrderService;

    @Override
    public BaseResponse<List<MallParentOrderDto>> findAllMallParentOrder() {
        return mallParentOrderQueryService.findAllMallParentOrder();
    }
    @Override
    public MallParentSubOrderNosDto getMallSubOrderNos(String parentOrderNo) {
        return mallParentOrderService.getMallSubOrderNos(parentOrderNo);
    }

    @Override
    public BaseResponse<SimpleParentOrderDto> getSimpleParentOrderDto(String parentOrderNo) {
        return mallParentOrderService.getSimpleParentOrderDto(parentOrderNo);
    }

    @Override
    public MallParentOrderDto findByOrderNo(String parentOrderNo) {
        return mallParentOrderQueryService.findByOrderNo(parentOrderNo);
    }

    @Override
    public MallParentOrderDto findParentOrderById(String parentOrderId) {
        return mallParentOrderQueryService.findParentOrderById(parentOrderId);
    }

    @Override
    public BaseResponse<String> findParentOrderNo(String id) {
        return mallParentOrderQueryService.findParentOrderNo(id);
    }




}
