package order.service.config;

import com.weibo.api.motan.config.springsupport.BasicRefererConfigBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import utils.Lang;

/**
 * Created by xiaoqian on 2016/9/27.
 */
//@Order(0)
@Configuration
public class CommonWebMotanConfig {

    @Bean(name = "motanClientBasicConfig")
    @ConditionalOnMissingBean
    public BasicRefererConfigBean baseRefererConfig(@Value("${motan.client.group:sinomall}")
                                                            String motanClientGroup, @Value("${motan.client.access.log:false}") Boolean motanClientAccessLog) {
        BasicRefererConfigBean config = new BasicRefererConfigBean();
        config.setProtocol("motan");
        //  config.setGroup("sinomall");
        if (Lang.isEmpty(motanClientGroup)) {
            config.setGroup("sinomall");
        } else {
            config.setGroup(motanClientGroup);
        }
        if (Lang.isEmpty(motanClientAccessLog)) {
            config.setAccessLog(false);
        } else {
            config.setAccessLog(motanClientAccessLog);
        }
        ///config.setModule("motan-demo-rpc");
        //config.setApplication("myMotanDemo");
        config.setRegistry("registry");
        config.setCheck(false);
        // config.setAccessLog(false);
        //config.setRetries(2);
        config.setRequestTimeout(360 * 1000);
        config.setThrowException(true);
        config.setDefault(true);
        //config.setFilter("active,switcher");
        return config;
    }
    /**
     * 不进行重试的Motan客户端配置
     * @return
     */
    @Bean(name = "motanClientFastFailConfig")
    public BasicRefererConfigBean clientFastFailConfig(@Value("${motan.client.group:sinomall}")
                                                               String motanClientGroup, @Value("${motan.client.access.log:false}") Boolean motanClientAccessLog) {
        BasicRefererConfigBean config = new BasicRefererConfigBean();
        config.setProtocol("motan");
        if(Lang.isEmpty(motanClientGroup)){
            config.setGroup("sinomall");
        }else {
            config.setGroup(motanClientGroup);
        }
        if(Lang.isEmpty(motanClientAccessLog)){
            config.setAccessLog(false);
        }else {
            config.setAccessLog(motanClientAccessLog);
        }
        config.setRegistry("registry");
        config.setCheck(false);
        config.setRequestTimeout(60*1000);
        config.setThrowException(true);
        config.setDefault(true);
        return config;
    }

}
