package order.service.events.listener;

import cart.api.dto.order.OrderJmsMessage;
import cart.api.dto.order.OrderMainDto;
import order.model.po.OrderMain;
import ma.glasnost.orika.MapperFacade;
import order.service.events.OrderCreateEvent;
import order.service.jms.JmsHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.stereotype.Component;
import store.api.dto.modeldto.core.StoreDto;
import utils.log.Log;
import utils.log.Logs;

/**
 * 协议订单创建事件监听
 * @author Liang Wenxu
 * @since 2018-01-12
 */
@Component
public class ProtocolOrderCreateEventListener implements SmartApplicationListener {
    Log log = Logs.getLog(ProtocolOrderCreateEventListener.class.getName());
    private static final String orgCode = "protocol";

    @Value("${activemq.queue.orderEvents:}")
    private String orderEventQueue;

    @Autowired
    JmsHelper jmsHelper;
    @Autowired
    MapperFacade mapperFacade;


    @Override
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType == OrderCreateEvent.class;
    }

    @Override
    public boolean supportsSourceType(Class<?> sourceType) {
        return sourceType == OrderMain.class;
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        OrderCreateEvent orderEvent = (OrderCreateEvent) event;
        OrderMain orderMain = (OrderMain) orderEvent.getSource();
//        String storeType = orderMainApi.orderStoreType(orderMain.getId());
        OrderMainDto orderMainDto = mapperFacade.map(orderMain, OrderMainDto.class);
        if(StoreDto.STORE_TYPE_PROTOCOL.equals(orderMain.getStoreType())) {
            log.info("orderNo: {0}, orgCode: {1} ,协议采购订单创建事件", orderMain.getOrderNo() , ((OrderCreateEvent) event).getOrgCode());

            // 创建JMS消息
            OrderJmsMessage message = OrderJmsMessage.newMessage(orderMainDto, OrderJmsMessage.OrderEvents.CREATED);
            jmsHelper.sendQueuedMessage(message, orderEventQueue);

        } else {
            log.info("orderNo: {0}, orgCode: {1} ,非协议采购订单创建事件", orderMain.getOrderNo(), ((OrderCreateEvent) event).getOrgCode());
        }

    }

    @Override
    public int getOrder() {
        return 0;
    }
}
