package order.service.events.listener;

import cart.api.dto.order.OrderJmsMessage;
import order.model.po.OrderMain;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import order.service.events.OrderEvent;
import order.service.events.OrderPassedEvent;
import order.service.jms.JmsHelper;
import order.service.service.OrderMainService;
import order.service.service.OrderService;
import order.vo.OrderStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.stereotype.Component;
import store.api.dto.modeldto.core.StoreDto;
import utils.GlobalContants;
import utils.Lang;

/**
 * 协议采购订单审核通过事件监听
 *
 * @author Liang Wenxu
 * @since 2018-01-31
 */
@Component
@Slf4j
public class ProtocolOrderPassedEventListener implements SmartApplicationListener {
    private static final String orgCode = "protocol";

    @Value("${activemq.queue.orderEvents:}")
    private String orderEventQueue;

    @Value("${finance.bills.message.queue.billscreate:}")
    private String billsCreateQueue;
    @Autowired
    MapperFacade mapperFacade;

    @Override
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType == OrderPassedEvent.class;
    }

    @Override
    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        OrderPassedEvent orderEvent = (OrderPassedEvent) event;
        OrderMain orderMain = (OrderMain) orderEvent.getSource();
        log.info("订单审核通过事件orderMain：{}", orderMain);
        if (!Lang.isEmpty(orderMain)) {
            /**
             * 增加审核通过时间
             */
            orderMainService.updateOrderAuditEndTime(orderMain.getId());
            if (StoreDto.STORE_TYPE_PROTOCOL.equals(orderMain.getStoreType())) {
                log.info("orderNo: {}, orgCode: {} ,协议采购订单审核通过事件", orderMain.getOrderNo(), ((OrderEvent) event).getOrgCode());
                // 协议采购订单审核通过后，修改订单状态为待确认
                OrderStatus orderStatus = new OrderStatus();
                orderStatus.setOrderId(orderMain.getId());
                orderStatus.setStatus(GlobalContants.ORDER_STATUS.WAIT_COMFIRM);
                orderService.statusChange(orderStatus);
                // orderMain.setStatus(OrderMain.order_status_wait_comfirm);
                orderMain.setStatus(OrderMain.order_status_wait_comfirm);
                orderMain.setSubOrders(null);
                orderMain.setOrderGifts(null);
                orderMain.setOrderAttrs(null);
                orderMain.setOrderItems(null);
                // 发送队列消息
                jmsHelper.sendQueuedMessage(OrderJmsMessage.newMessage(
                        orderMainService.transToDto(orderMain), OrderJmsMessage.OrderEvents.STATUS_CHANGED), orderEventQueue);
            }
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Autowired
    OrderMainService orderMainService;

    @Autowired
    JmsHelper jmsHelper;

    @Autowired
    OrderService orderService;
}
