package order.service.factory;

import order.service.order.templates.BatchOrderTemplate;
import order.service.order.templates.OrderTemplate;
import order.vo.OrderTemplateConfigKey;
import org.hibernate.engine.jdbc.batch.spi.Batch;

/**
 * 订单操作模板获取工厂接口
 * @author Liang Wenxu
 * @since 2018/7/9
 */
public interface BatchOrderTemplateFactory {

    /**
     * 根据店铺代码获取订单操作模型
     * @param orderTemplateKey 订单操作模板的索引，其中templateName可不传
     * @return
     */
    BatchOrderTemplate getOrderTemplate(OrderTemplateConfigKey orderTemplateKey);
}
