package order.service.factory;

import order.service.order.templates.OrderTemplate;
import order.vo.GoodsInfoVo;
import order.vo.OrderTemplateConfigKey;

/**
 * 订单操作模板获取工厂接口
 * @author Liang Wenxu
 * @since 2018/7/9
 */
public interface OrderTemplateFactory {

    /**
     * 根据店铺代码获取订单操作模型
     * @param orderTemplateKey 订单操作模板的索引，其中templateName可不传
     * @return
     */
    OrderTemplate getOrderTemplate(OrderTemplateConfigKey orderTemplateKey);
}
