package order.service.operator;

import order.vo.TempOrderVo;
import order.vo.TempSubOrderVo;
import order.vo.response.OrderFreight;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 订单运费相关操作接口
 * @author Liang Wenxu
 * @since 2018/7/27
 */
public interface OrderFreightOperator {
    /**
     * 查询运费
     * @param tempOrderVo 临时订单实体，请求中的areaCode为最末级地区代码
     * @return 返回的临时订单对象包括了父子结构，父子结构将与tempOrder中的保持一致
     */
    OrderFreight get(TempOrderVo tempOrderVo);

    /**
     * 直接更新运费
     * 更多请参见{@link OrderFreightOperator#get(TempOrderVo)}
     * @param tempOrderVo
     */
    void update(TempOrderVo tempOrderVo);

    /**
     * 从tempOrderVo中生成默认的OrderFreight对象，默认的运费都为0
     * @param tempOrderVo
     * @return
     */
    public static OrderFreight defaultFromTempOrder(TempOrderVo tempOrderVo) {
        OrderFreight orderFreight = new OrderFreight();
        orderFreight.setOrderNo(tempOrderVo.getTmpOrderNo());
        orderFreight.setBaseFreight(new BigDecimal(0));
        if(tempOrderVo.getSubOrders() != null && tempOrderVo.getSubOrders().size() > 0) {
            List<OrderFreight> subOrderFreights = new ArrayList<>();
            for(TempSubOrderVo tempSubOrderVo : tempOrderVo.getSubOrders()) {
                subOrderFreights.add(defaultFromTempSubOrder(tempSubOrderVo));
            }
            orderFreight.setSubOrderFreights(subOrderFreights);
        }
        return orderFreight;
    }

    /**
     * 从tempSubOrderVo中生成默认的OrderFreight对象，默认的运费都为0
     * @param tempSubOrderVo
     * @return
     */
    public static OrderFreight defaultFromTempSubOrder(TempSubOrderVo tempSubOrderVo) {
        OrderFreight orderFreight = new OrderFreight();
        orderFreight.setOrderNo(tempSubOrderVo.getTmpOrderNo());
        orderFreight.setBaseFreight(new BigDecimal(0));
        if(tempSubOrderVo.getSubOrders() != null && tempSubOrderVo.getSubOrders().size() > 0) {
            List<OrderFreight> subOrderFreights = new ArrayList<>();
            for(TempSubOrderVo sso : tempSubOrderVo.getSubOrders()) {
                OrderFreight of = new OrderFreight();
                of.setBaseFreight(BigDecimal.valueOf(0));
                of.setOrderNo(sso.getTmpOrderNo());
                if(sso.getSubOrders() != null && sso.getSubOrders().size() > 0) {
                    of.setSubOrderFreights(new ArrayList<>());
                    for(TempSubOrderVo ssso : sso.getSubOrders()) {
                        of.getSubOrderFreights().add(defaultFromTempSubOrder(ssso));
                    }
                }
                subOrderFreights.add(of);
            }
            orderFreight.setSubOrderFreights(subOrderFreights);
        }
        return orderFreight;
    }
}
