package order.service.operator;

import order.exceptions.IllegalAreaCodeException;
import order.vo.TempOrderVo;
import order.vo.TempSubOrderVo;
import order.vo.response.OrderPrice;

import java.util.List;

/**
 * 订单金额操作者接口
 * @author Liang Wenxu
 * @since 2018/7/26
 */
public interface OrderPriceOperator {
    /**
     * 获取订单金额
     * @param tempOrderVo 临时订单VO，将生成的实例整体怼过来，别瞎改里面的东西
     * @return 返回订单的价格实体，父子结构与tempOrder中将保持一致，itemStocks保存商品的库存详情，如为父订单则会包括所有子单的商品
     */
    OrderPrice get(TempOrderVo tempOrderVo) throws IllegalAreaCodeException;

    /**
     * 根据临时子订单获取订单金额
     * @param subOrder 子订单
     * @param areaNodes 地区编码NodeList，下标0为省、1为市、2为区、3为街道县...中间节点不能空，末级节点可为空，例如广州：[440000, 440100, 440103]
     * @return
     * @throws IllegalAreaCodeException 当所给出地区有误时抛出此异常
     */
    OrderPrice get(TempSubOrderVo subOrder, List<String> areaNodes) throws IllegalAreaCodeException;
}
