package order.service.operator;

import order.exceptions.IllegalAreaCodeException;
import order.vo.TempOrderVo;
import order.vo.TempSubOrderVo;
import order.vo.response.OrderStock;

/**
 * 订单库存操作者接口
 * @author Liang Wenxu
 * @since 2018/7/26
 */
public interface OrderStockOperator {
    /**
     * 获取订单库存
     * @param tempOrderVo 临时订单VO，将生成的实例整体怼过来，别瞎改里面的东西
     * @return 返回订单的库存装状态，父子结构与tempOrder中将保持一致，itemStocks保存商品的库存详情，如为父订单则会包括所有子单的商品
     */
    OrderStock get(TempOrderVo tempOrderVo) throws IllegalAreaCodeException;

    /**
     * 获取订单库存
     * @param tempOrderVo 临时订单VO，将生成的实例整体怼过来，别瞎改里面的东西
     * @param areaCode
     * @param organizationalId
     * @return 返回订单的库存装状态，父子结构与tempOrder中将保持一致，itemStocks保存商品的库存详情，如为父订单则会包括所有子单的商品
     */
    OrderStock get(TempSubOrderVo tempOrderVo, String areaCode, String organizationalId) throws IllegalAreaCodeException;
}
