package order.service.order.helper;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import member.api.dto.shop.MemberAddressDto;
import member.api.dto.shop.MemberDto;
import order.Contants;
import order.model.po.*;
import order.service.config.SequenceConfig;
import order.service.events.OrderEvent;
import order.service.events.OrderStatusChangeEvent;
import order.service.operator.OrderPriceOperator;
import order.service.service.query.OrderMainQueryService;
import order.service.stubs.*;
import order.service.utils.SequenceUtil;
import order.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import outsideapi.vo.HandlerRespVo;
import outsideapi.vo.jdorder.CSku;
import outsideapi.vo.order.TrdOrder;
import outsideapi.vo.order.TrdOrderSku;
import store.api.dto.modeldto.core.StoreDto;
import utils.GlobalContants;
import utils.Lang;
import utils.spring.SequenceGenerator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 临时订单相关Helper
 * @author Liang Wenxu
 * @since 2018/7/16
 */
@Component
@Slf4j
public class OrderHelper {
    @Value("${spring.profiles.active}")
    private String activeEnv;

    @Value("${order.orderno.prefix:}")
    private String ORDER_NO_PREFIX;
    @Value("${order.orderno.dbkey:}")
    private String ORDER_NO_KEY;
    @Value("${order.orderno.size:10}")
    private Integer ORDER_NO_SIZE;

    @Autowired
    private SequenceGenerator sequenceGenerator;

    @Autowired
    SalesPriceRateApiStub salesPriceRateApi;

    @Autowired
    MemberAddressApiStub memberAddressApi;

    @Autowired
    OutsideProductApiStub outsideProductApi;

    @Autowired
    StoreApiStub storeApi;

    @Autowired
    OrderPriceOperator orderPriceOperator;

    @Autowired
    ApplicationContext applicationContext;

    @Autowired
    OrderMainQueryService orderMainQueryService;

    @Autowired
    OrganizationApiStub organizationApi;
    @Autowired
    SequenceUtil sequenceUtil;


    private static final String ORDER_NO_SEQUENCE_KEY = "ORDER_NO";

    /**
     * 创建初始化订单
     * @param request
     * @param subOrder
     * @param memberDto
     * @return
     */
    public OrderMain genOrder(CreateOrderRequest request, TempSubOrderVo subOrder, MemberDto memberDto) {
        OrderMain order = new OrderMain();
        order.setOrderNo(this.generateOrderNo());
        order.setRealOrganizationId(request.getRealOrganizationId());

        StoreDto storeDto = storeApi.getStoreInfo(subOrder.getStoreId());
        MemberAddressDto address = memberAddressApi.findById(request.getMemberAddrId());
        order.setAddressId(request.getMemberAddrId());
        order.setMemberId(request.getMemberId());
        order.setOrganizationId(request.getRealOrganizationId());
        order.setSumPrice(subOrder.getNeedPayPrice()); // 包含运费
        order.setSumNofreightPrice(subOrder.getSumPrice()); // 不包含运费
        order.setOrderItems(new ArrayList<>());
        order.setOrderMode(subOrder.getOrderMode());
        order.setGoodsType(subOrder.getGoodsType());

        // 回写购买人信息
        if (address != null) {
            order.setRecipientName(address.getUsername());
        }
//        order.setStatus(OrderMain.order_status_obligation);
        /** 如果是第三方商户，订单状态改为新建，占用库存成功后再回写为待付款 */
        HandlerRespVo<Boolean> respVo = outsideProductApi.isOutsideStore(subOrder.getStoreId());
        if (respVo.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS) && respVo.getData()) {
            order.setStatus(OrderMain.order_status_neworder);
        } else {
            order.setStatus(OrderMain.order_status_obligation);
        }
        order.setStoreId(storeDto.getId());//店鋪id
        order.setCreateTime(new Date());//shijian
        order.setFreight(subOrder.getSumShippingFee());//运费默认0
        // 运费减免金额
        order.setFreeFreight(BigDecimal.ZERO);
        order.reCalSumPrice();
        order.setUsageCode(request.getUsageCode());
        if (order.getRealOrganizationId() == null) {
            order.setRealOrganizationId(order.getOrganizationId());
        }
        order.setStoreType(storeDto.getStoreExt().getType());
        order.setStoreName(storeDto.getStoreExt().getStoreName());
        order.setStoreCode(storeDto.getStoreExt().getCode());

        // 设置支付方式
        order.setPayMethod(request.getPaymentCode());

        // 设置订单附加属性
        OrderMainAttr orderMainAttr;
        order.setOrderAttrs(new ArrayList<>());
        if (request.getOrderAttrs() != null) {
            for (OrderAttrVo attrVo : request.getOrderAttrs()) {
                orderMainAttr = new OrderMainAttr();
                orderMainAttr.setOrder(order);
                orderMainAttr.setAttrName(attrVo.getAttrName());
                orderMainAttr.setAttrValue(attrVo.getAttrValue());
                orderMainAttr.setType(Lang.isEmpty(attrVo.getType()) ? OrderMainAttr.ORDER_ATTR_TYPE_JSON_LIST : attrVo.getType());
                order.getOrderAttrs().add(orderMainAttr);
            }
        }

        // 设置订单Item
        order.setOrderItems(this.genOrderItems(subOrder, order, address));

        /**
         * 保存orderMain的其他信息
         */
        /**
         * 设置浏览器信息
         * Roney add 20171016
         * start
         */
        order.setBuyType(request.getBuyType());
        order.setHeadMessage(request.getHeadMessage());
        order.setBrowserType(request.getBrowserType());
        order.setPlatformType(request.getPlatformType());

        /**
         * 设置浏览器信息
         * Roney add 20171016
         * end
         */
        order.setRequestId(request.getRequestId());
        log.info("tempOrderVo.getRequestId{}", request.getRequestId());

        /**
         * 保存信息参数，直接将参数转成map保存
         * Roney add 20171126
         * start
         */
        order.setPostDesc(JSONObject.toJSONString(request));
        if(Lang.isEmpty(request.getRequestId())){
            order.setRequestId(request.getTmpOrderNo());
        }
        /**
         * 保存信息参数，直接将参数转成map保存
         * Roney add 20171126
         * end
         */

        return order;
    }

    /**
     * 为订单创建商品条目
     * @param subOrder 临时订单，将根据临时订单中的orderItems列表进行订单条目生成
     * @param order 已创建的订单实体，用于Hibernate关联维护
     * @param memberAddress 用户选择的地址
     * @return 返回OrderItem列表，其中的OrderMain反向关联已维护
     */
    public List<OrderItem> genOrderItems(TempSubOrderVo subOrder, OrderMain order, MemberAddressDto memberAddress) {
        // 商品总数
        int totalCounts = 0;
        // 订单条目
        OrderItem orderItem;
        List<OrderItem> orderItems = new ArrayList<>();
//
//        FashionPriceRequestVo fashionPriceRequestVo = new FashionPriceRequestVo();
//        fashionPriceRequestVo.setCityCode(memberAddress.getCityCode());
//        fashionPriceRequestVo.setProvinceCode(memberAddress.getProvinceCode());
//        fashionPriceRequestVo.setCountyCode(memberAddress.getAreaCode());
//        fashionPriceRequestVo.setTownCode(memberAddress.getTownCode());
//        fashionPriceRequestVo.setFashionPriceParamVos(new ArrayList<>());
        for (TempOrderItemVo c : subOrder.getOrderItems()) {
//            FashionPriceParamVo fashionPriceParamVo = new FashionPriceParamVo();
//            fashionPriceParamVo.setFactionId(c.getProductFashionId());
//            fashionPriceParamVo.setProductCode(c.getProductCode());
//            fashionPriceRequestVo.getFashionPriceParamVos().add(fashionPriceParamVo);
            totalCounts++;
            orderItem = generateOrderItem(c);

            // 处理子商品
            if (c.getChildren() != null && c.getChildren().size() > 0) {
                OrderItem childOrderItem;
                List<OrderItem> childOrderItemList = new ArrayList<>();
                for (TempOrderItemVo cc : c.getChildren()) {
                    childOrderItem = generateOrderItem(cc);
                    childOrderItem.setParent(orderItem);
                    childOrderItemList.add(childOrderItem);
                }
                orderItem.setChildren(childOrderItemList);
            }
            orderItem.setOrder(order);
            orderItems.add(orderItem);
        }

        return orderItems;
    }
    /**
     * 序列生成订单号
     *
     * @return
     */
    public String generateOrderNo() {
        try {
            return sequenceUtil.getOrderNo(ORDER_NO_SEQUENCE_KEY);
        } catch (InterruptedException e) {
            throw new RuntimeException("生成订单号失败");
        }

    }

    /**
     * 检查订单价格错误
     * @param order 生成的订单
     * @return 当存在价格错误时，返回false
     */
//    public Boolean hasPriceError(TempSubOrderVo tempSubOrder) {
//        List<TempSubOrderVo> subOrderVoList = new ArrayList<>();
//        subOrderVoList.add(tempSubOrder);
//        orderPriceOperator.get(subOrderVoList, );
//
//
//    }

    /**
     * 生成OrderItem
     * @param tempOrderItemVo 临时订单商品对象
     * @return
     */
    private OrderItem generateOrderItem(TempOrderItemVo tempOrderItemVo) {
        OrderItem orderItem = new OrderItem();
        orderItem.setCount(tempOrderItemVo.getCount());
        orderItem.setProductName(tempOrderItemVo.getFashionTitle());//商品名称
        orderItem.setCostPrice(tempOrderItemVo.getCostPrice());
        orderItem.setSalePrice(tempOrderItemVo.getSalePrice());
        orderItem.setOrginSalePrice(tempOrderItemVo.getOrginSalePrice());
        orderItem.setProductPrice(tempOrderItemVo.getMarketPrice());
        orderItem.setMemberPrice(orderItem.getSalePrice());
        orderItem.setFinalPrice(tempOrderItemVo.getSalePrice());
        orderItem.setSeckillPrice(tempOrderItemVo.getSalePrice());
        orderItem.setActivityId(tempOrderItemVo.getActivityId());
        orderItem.setGoodsId(tempOrderItemVo.getGoodsId());
        orderItem.setProductFashId(tempOrderItemVo.getProductFashionId());
        orderItem.setProductId(tempOrderItemVo.getProductId());
        orderItem.setSku(tempOrderItemVo.getProductCode());
        orderItem.setSalePriceRate(tempOrderItemVo.getSalesPriceRate());
        orderItem.setProductType(tempOrderItemVo.getProductType());
        orderItem.setProductPic(tempOrderItemVo.getFashionPic());
        orderItem.setBusinessCode(tempOrderItemVo.getBusinessCode());
        return orderItem;
    }

    /**
     * 发布一个订单事件
     *
     * @param orderEvent
     */
    public void publishOrderEvent(OrderEvent orderEvent) {
        applicationContext.publishEvent(orderEvent);
    }

    /**
     * 触发指定订单的状态改变事件
     * @param orderKey
     */
    public void publishOrderStatusChangeEvent(OrderKey orderKey, String operator) {
        OrderMain orderMain;
        if(!Lang.isEmpty(orderKey.getOrderId())) {
            orderMain = orderMainQueryService.getOrder(orderKey.getOrderId());
        } else {
            orderMain = orderMainQueryService.findByOrderNo(orderKey.getOrderNo());
        }

        if (orderMain != null) {
            String orgCode = organizationApi.findOrganizationCodeById(orderMain.getOrganizationId());
            publishOrderEvent(new OrderStatusChangeEvent(orderMain, orgCode, Lang.isEmpty(operator) ? Contants.ORDER_OPERATOR_SYSTEM : operator));

        }
    }

    /**
     * 触发指定订单的状态改变事件
     * @param orderKey
     * @param status
     */
    public void publishOrderStatusChangeEvent(OrderKey orderKey, GlobalContants.ORDER_STATUS status, String operator) {
        OrderMain orderMain = orderMainQueryService.findByKey(orderKey);
        if (orderMain != null) {
            String orgCode = organizationApi.findOrganizationCodeById(orderMain.getOrganizationId());

            if(status == null || !orderMain.getStatus().equals(status.getValue())) {
                // 如果给出了status，则只有在订单状态被改变后，才触发事件
                publishOrderEvent(new OrderStatusChangeEvent(orderMain, orgCode, Lang.isEmpty(operator) ? Contants.ORDER_OPERATOR_SYSTEM : operator));
            }
        }
    }

    public static SubOrder toSubOrder(TrdOrder trdOrder, OrderMain order) {
        SubOrder subOrder = new SubOrder();
        subOrder.setOrder(order);
        subOrder.setSubOrderNo(trdOrder.getTrdOrderNo());
        /**Akers 2017-06-28修改： 保存子订单状态 START */
        subOrder.setTrdSpState("" + trdOrder.getState());
        subOrder.setTrdOrderState("" + trdOrder.getOrderstate());
        subOrder.setTrdSubmitState("" + trdOrder.getSubmitstate());
        /**Akers 2017-06-28修改： 保存子订单状态 END */
        List<TrdOrderSku> cskus = trdOrder.getSku();
        List<SubOrderItem> subOrderItems = new ArrayList<>();
        //4.2.3根据cskus生成我们的subOrderItem
        BigDecimal sumCostPrice = BigDecimal.ZERO;
        for (TrdOrderSku cSku : cskus) {
            SubOrderItem subOrderItem = new SubOrderItem();
            subOrderItem.setCount(cSku.getNum());
            subOrderItem.setOrder(order);
            order.getOrderItems().stream().filter(it -> it.getSku().equals(cSku.getSkuId())).findFirst().ifPresent(it -> subOrderItem.setOrderItem(it));//C);
            subOrderItem.setSubOrder(subOrder);//D
            if(!Lang.isEmpty(cSku.getType())) {
                subOrderItem.setType(Integer.valueOf(cSku.getType()));
                if(cSku.getType()==CSku.TYPE_GENERAL.toString()) {//只有普通商品才需要加价格
                    sumCostPrice = sumCostPrice.add(subOrderItem.getOrderItem().getCostPrice().multiply(BigDecimal.valueOf(cSku.getNum())));
                }
            }
            subOrderItem.setPrice(cSku.getPrice());
            subOrderItem.setName(cSku.getName());
            subOrderItem.setTaxPrice(cSku.getTaxPrice());
            subOrderItem.setSkuId(cSku.getSkuId());
            subOrderItem.setNakedPrice(cSku.getTaxPrice());

            subOrderItems.add(subOrderItem);
        }
        subOrder.setFreight(trdOrder.getFreight());
        subOrder.setSumCostPrice(sumCostPrice);
        subOrder.setSubOrderItems(subOrderItems);
        return subOrder;
    }
}
