package order.service.order.templates;

import order.Contants;
import order.exceptions.IllegalAreaCodeException;
import order.exceptions.NoStockException;
import order.exceptions.OrderCreateException;
import order.exceptions.temporder.TempOrderCreateException;
import order.service.operator.OrderFreightOperator;
import order.vo.*;
import order.vo.response.OrderAuditingResult;
import order.vo.response.OrderFreight;
import order.vo.response.OrderStock;
import outsideapi.exceptions.SupplierInterfaceInvokeException;
import outsideapi.exceptions.SupplierOrderComfirmFalidException;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * 订单处理模型适配器，所有订单处理模型实现类的基类，此类提供订单操作的默认模板，各个性实现请酌情覆盖
 * <p><b>Notic:适配器中实现的方法均为降级实现，方便进行调试或跳过业务节点，在编写各业务场景的实现时，请注意将所需的业务节点方法覆盖到位！</b></p>
 * @author Liang Wenxu
 * @since 2018/7/9
 */
public abstract class OrderTemplateAdapter implements OrderTemplate {
    @Override
    public TempOrderVo createTempOrder(final TempOrderCreateRequest tempOrderCreateRequest) throws TempOrderCreateException {
        return new TempOrderVo();
    }

    @Override
    public BaseResponse<OrderStock> validateStock(TempSubOrderVo tempOrderVo, String areaCode, String organizationId) throws IllegalAreaCodeException {
        // 校验库存的降级实现->直接返回有库存
        OrderStock orderStock = new OrderStock();
        orderStock.setHasNoStock(false);
        return new BaseResponse<>(true, "SUC", orderStock);
    }

    @Override
    public BaseResponse<OrderFreight> getFreight(TempOrderVo tempOrderVo) {
        // 运费计算的的降级实现->直接返回有0运费
        return new BaseResponse<>(true, "SUC", OrderFreightOperator.defaultFromTempOrder(tempOrderVo));
    }

    @Override
    public BaseResponse<Boolean> orderPreCheck(TempOrderVo tempOrderVo) {
        return new BaseResponse<>(true, "SUC", true);
    }

    @Override
    public OrderVo createOrder(CreateOrderRequest request) throws OrderCreateException, NoStockException {
        return new OrderVo();
    }

    /**
     * 订单审核（单个），审核通过订单可进入生产状态（待支付），审核不通过则取消订单
     *
     * @param orderKeys           需操作的订单索引
     * @param passed              true|false（审核通过|审核不通过）
     * @return 返回中包括各订单的审核处理情况
     */
    @Override
    public List<OrderAuditingResult> audit(List<OrderKey> orderKeys, Boolean passed) {
        return null;
    }

    @Override
    public BaseResponse<Boolean> subscribeOrder(OrderVo orderVo) {
        return new BaseResponse<>(true, "SUC", true);

    }

    @Override
    public BaseResponse<Boolean> marketingDone(TempOrderVo tempOrderVo) {
        return new BaseResponse<>(true, "SUC", true);

    }

    @Override
    public BaseResponse<Boolean> orderPayPreSubmitDone(OrderVo orderVo) {
        return new BaseResponse<>(true, "SUC", true);

    }

    @Override
    public OrderPayConfirmResp paySubmit(OrderVo orderVo) throws SupplierInterfaceInvokeException, SupplierOrderComfirmFalidException {
        OrderPayConfirmResp orderPayConfirmResp = new OrderPayConfirmResp();
        orderPayConfirmResp.setSuccess(true);
        return orderPayConfirmResp;
    }

    @Override
    public BaseResponse<CancelOrderResp> cancelOrder(List<OrderKey> orderKeys, Contants.CancelOrderType cancelType) {
        return new BaseResponse<>(true, "SUC", new CancelOrderResp());
    }

    /**
     * 订单收货
     *
     * @param orderKey    订单ID或orderNo
     * @param receiptType 订单收货类型，见{@link Contants}中ORDER_RECEIPT_TYPE_开头
     */
    @Override
    public void orderReceipt(OrderKey orderKey, String receiptType) {

    }

    /**
     * 刷新订单状态
     *
     * @param orderKeys
     * @return
     */
    @Override
    public BaseResponse<List<OrderVo>> refresh(List<OrderKey> orderKeys) {
        return null;
    }
}
