package order.service.service;

import activities.api.ActivityConfigurationApi;
import activities.api.ActivityGoodsApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cart.api.vo.CartItemVo;
import cart.api.vo.TempOrderItemVo;
import cart.api.vo.TempOrderStoreVo;
import cart.api.vo.TempOrderVo;
import cms.api.DepositHistoryApi;
import cms.api.OrganizationApi;
import cms.api.OrganizationCreditsApi;
import cms.api.dto.DepositHistoryDto;
import cms.api.dto.OrganizationCreditsDto;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import payment.model.po.Payment;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.*;
import goods.dto.product.ProductFashionDto;
import goods.vo.SalesPriceCalVo;
import jdek.api.service.JdekApi;
import ma.glasnost.orika.MapperFacade;
import member.api.*;
import member.api.dto.shop.MemberAddressDto;
import member.api.dto.shop.MemberCreditsTranDto;
import member.api.dto.shop.MemberDto;
import order.Contants;
import order.model.po.*;
import order.model.repository.*;
import order.service.order.helper.OrderHelper;
import order.service.service.query.OrderMainQueryService;
import order.service.stubs.GroupBuyingApiStub;
import order.service.stubs.MemberApiStub;
import order.service.stubs.SalesPriceRateQueryApiStub;
import order.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.api.OutsideProductApi;
import outsideapi.vo.*;
import outsideapi.vo.order.TrdOrder;
import outsideapi.vo.order.TrdOrderSku;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import sysmg.api.SystemConfigApi;
import sysmg.api.SystemLogApi;
import sysmg.dto.SystemConfigDto;
import sysmg.dto.SystemLogDto;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.date.DateUtils;
import utils.lang.Copys;
import utils.log.Log;
import utils.log.Logs;
import utils.rpc.motan.ApiResponseVo;
import utils.spring.SequenceGenerator;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Predicate;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import static cart.api.OrderMainApi.CancelOrderType;


/**
 * Created by Liang Wenxu on 2016/11/21.
 */
@Component
@Transactional(readOnly = true)
public class OrderMainService {
    private final static Log logs = Logs.getLog(OrderService.class.getName());

    @Value("${spring.profiles.active}")
    private String activeEnv;

    @Value("${order.orderno.envprefix:DEV}")
    private String envPrefix;

//    @Autowired
//    private RedisTemplate<String, Object> redisTemplate;

    @Resource(name = "redisTemplate")
    ValueOperations<String, BigDecimal> shippingFeeOps;

    @Resource(name = "redisTemplate")
    ValueOperations<String, FashionPriceVo> productPriceOps;

    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public OrderMainService() {
    }


    public void saveSuccessLog(String orderNo, CancelOrderType cancelType, ApiResponseVo responseVo, ApiResponseVo apiResponseVo) {
        responseVo.setStatus(GlobalContants.ResponseStatus.SUCCESS);
        responseVo.setMessage(apiResponseVo.getMessage());
        SystemLogDto systemLog = new SystemLogDto();
        systemLog.setLogType(SystemLogDto.LOG_TYPE_INFO);
        systemLog.setLogSource(SystemLogDto.LOG_SOURCE_JICAI);
        systemLog.setErrorDesc("取消城通积分订单返还成功！" + apiResponseVo.getMessage());
        systemLog.setPostUrl("orderNo: " + orderNo + ", cancelType: " + cancelType.toString());
        systemLogApi.saveBean(systemLog);
    }

    public void saveErrorLog(String orderNo, CancelOrderType cancelType, ApiResponseVo responseVo, ApiResponseVo apiResponseVo) {
        responseVo.setStatus(GlobalContants.ResponseStatus.ERROR);
        responseVo.setMessage(apiResponseVo.getMessage());
        SystemLogDto systemLog = new SystemLogDto();
        systemLog.setLogType(SystemLogDto.LOG_TYPE_ERROR);
        systemLog.setLogSource(SystemLogDto.LOG_SOURCE_JICAI);
        systemLog.setErrorDesc("取消城通积分订单返还积分失败！" + apiResponseVo.getMessage());
        systemLog.setPostUrl("orderNo: " + orderNo + ", cancelType: " + cancelType.toString());
        systemLogApi.saveBean(systemLog);
    }

    private void backActivityGoodsStockAndSolcNum(OrderMain orderMain, String organizationCode) {
        for (OrderItem orderItem : orderMain.getOrderItems()) {
            if (!Lang.isEmpty(orderItem.getActivityId())) {
                activityGoodsApi.backActivityGoodsStockAndSolcNum(orderItem.getGoodsId(), orderItem.getActivityId(), orderItem.getCount(), organizationCode);
            }
        }
    }

    private void generateDepositHistory(BigDecimal totalPrice, String memberId, OrganizationDto organization) {
        DepositHistoryDto depositHistory = new DepositHistoryDto();
        depositHistory.setDepositType(DepositHistoryDto.DESPOSIT_TYPE_CANCEL_ORDER);
        depositHistory.setDepositMoney(totalPrice);
        depositHistory.setDepositUserId(memberId);
        MemberDto member = memberApi.findMemberById(memberId);
        depositHistory.setDepositUserName(member.getCoreUser().getUsername());
        depositHistory.setOrganization(organization);
        depositHistory.setRemark("用户：" + member.getCoreUser().getUsername() + "在" + DateUtils.getNowTime() + "取消了订单，发起退款金额为" + totalPrice + "元");
        depositHistoryApi.saveDepositHistory(depositHistory);
    }

    public void prePayOrder(String orderNo) {
        //修改订单状态为预支付状态
        orderRepos.updateStatusByOrderNo(OrderMain.order_status_obligation, orderNo);
        updateGoodsSaleCount(OrderMain.order_status_obligation, orderNo);
    }


    /**
     * 深拷贝OrderMain对象，主要用于防止Hibernate序列化懒加载Session关闭问题
     * <p>
     * //     * @param order
     *
     * @return
     */
    public OrderMain cpyOrder(OrderMain from, OrderMain to) {
        OrderMain orderMainNew = to == null ? new OrderMain() : to;
//        if (StringUtils.isNotBlank(order.getId())) {
//            orderMainNew = orderRepos.getOne(order.getId());
//        }
        Copys copys = Copys.create();
        List<OrderItem> orderItemList = new ArrayList<>();
        List<SubOrder> subOrders = new ArrayList<>();
        List<OrderGift> orderGifts = new ArrayList<>();
        List<OrderMainAttr> orderMainAttrs = new ArrayList<>();
        OrderItem orderItemTmp;
        SubOrder subOrderTmp;
        OrderGift orderGiftTmp;
        OrderMainAttr orderMainAttrTmp;
        if (from == null) {
            return null;
        }
        copys.from(from).excludes("orderItems", "subOrders", "orderGifts", "orderAttrs").to(orderMainNew).clear();
        if (!Lang.isEmpty(from.getOrderItems())) {
            for (OrderItem i : from.getOrderItems()) {
                orderItemTmp = new OrderItem();
                copys.from(i).excludes("order").to(orderItemTmp).clear();
                orderItemTmp.setOrder(orderMainNew);
                orderItemList.add(orderItemTmp);
            }

            orderMainNew.setOrderItems(orderItemList);
        }


        SubOrderItem subOrderItem;
        if (from.getSubOrders() != null) {
            for (SubOrder s : from.getSubOrders()) {
                List<SubOrderItem> subOrderItemList = new ArrayList<>();
                subOrderTmp = new SubOrder();
                copys.from(s).excludes("order", "subOrderItems").to(subOrderTmp).clear();
                subOrderTmp.setOrder(from);

                for (SubOrderItem soi : s.getSubOrderItems()) {
                    subOrderItem = new SubOrderItem();
                    copys.from(soi).excludes("order", "subOrder", "orderItem").to(subOrderItem).clear();
                    subOrderItem.setOrder(orderMainNew);
                    subOrderItem.setSubOrder(subOrderTmp);
                    subOrderItemList.add(subOrderItem);
                    if (!Lang.isEmpty(soi.getOrderItem())) {
                        for (OrderItem i : orderMainNew.getOrderItems()) {
                            if (i.getId().equals(soi.getOrderItem().getId())) {
                                subOrderItem.setOrderItem(soi.getOrderItem());
                            } else {
                                subOrderItem.setOrderItem(soi.getOrderItem());
                            }
                        }
                    }
                }

                subOrderTmp.setSubOrderItems(subOrderItemList);
                subOrders.add(subOrderTmp);
            }
            orderMainNew.setSubOrders(subOrders);
        }


        if (from.getOrderGifts() != null) {
            for (OrderGift og : from.getOrderGifts()) {
                orderGiftTmp = new OrderGift();
                copys.from(og).excludes("order").to(orderGiftTmp).clear();
                orderGiftTmp.setOrder(orderMainNew);
                orderGifts.add(orderGiftTmp);
            }
            orderMainNew.setOrderGifts(orderGifts);
        }

        if (from.getOrderAttrs() != null) {
            for (OrderMainAttr attr : from.getOrderAttrs()) {
                orderMainAttrTmp = new OrderMainAttr();
                copys.from(attr).excludes("order").to(orderMainAttrTmp).clear();
                orderMainAttrTmp.setOrder(orderMainNew);
                orderMainAttrs.add(orderMainAttrTmp);
            }
            orderMainNew.setOrderAttrs(orderMainAttrs);
        }


        return orderMainNew;
    }

    /**
     * 获取第三方销售价格，主要用于苏宁等需实时获取商户价格的供应商
     *
     * @param tempOrderVo
     * @param areaCodeList
     * @param usePriceCache 是否使用价格缓存
     * @return
     */
    public TempOrderVo updateOutsidePrices(TempOrderVo tempOrderVo, Map<Integer, String> areaCodeList, Boolean usePriceCache) {
        for (TempOrderStoreVo storeVo : tempOrderVo.getStoreList()) {

            if (areaCodeList != null) {
                FashionPriceRequestVo fashionPriceRequestVo = new FashionPriceRequestVo(areaCodeList);
                fashionPriceRequestVo.setFashionPriceParamVos(new ArrayList<FashionPriceParamVo>());

                for (TempOrderItemVo orderItemVo : storeVo.getOrderItems()) {
                    fashionPriceRequestVo.getFashionPriceParamVos().add(new FashionPriceParamVo(
                            orderItemVo.getProductFashionId(), orderItemVo.getProductCode()));
                }
                List<FashionPriceParamVo> needQueryList = null;
                List<FashionPriceVo> resultFashionPrice = new ArrayList<>();
                if (usePriceCache) {
                    needQueryList = new ArrayList<>();
                    for (FashionPriceParamVo it : fashionPriceRequestVo.getFashionPriceParamVos()) {
                        FashionPriceVo price = getProductPriceInCache(storeVo.getStoreId(), it.getProductCode());
                        if (price == null) {
                            needQueryList.add(it);
                        } else {
                            // 加入返回列表中
                            resultFashionPrice.add(price);
                        }
                    }
                    fashionPriceRequestVo.setFashionPriceParamVos(needQueryList);
                }

                // 缓存获取不到的商品或未启用缓存时，通过接口获取
                if (fashionPriceRequestVo.getFashionPriceParamVos().size() > 0) {
                    HandlerRespVo<List<FashionPriceVo>> outsideApiRes = outsideProductApi.queryFashionPrice(storeVo.getStoreId(), fashionPriceRequestVo);
                    if (outsideApiRes != null && outsideApiRes.getStatus() == HandlerRespVo.RESPONSE_STATUS_SUCCESS && !Lang.isEmpty(outsideApiRes.getData())) {
                        resultFashionPrice.addAll(outsideApiRes.getData());
                        // 更新缓存
                        outsideApiRes.getData().forEach(it -> {
                            setProductPriceInCache(storeVo.getStoreId(), it.getProductCode(), it);
                        });
                    }
                }

                resultFashionPrice.forEach(r -> {
                    Optional<TempOrderItemVo> optional = storeVo.getOrderItems().stream()
                            .filter(tempOrderItemVo -> tempOrderItemVo.getProductFashionId().equals(r.getFashionId()))
                            .findFirst();
                    if (optional.isPresent()) {
                        TempOrderItemVo orderItemVo = optional.get();
                        orderItemVo.setSalePrice(r.getSalePrice());
                        orderItemVo.setMarketPrice(r.getMarketPrice());
                        orderItemVo.setCostPrice(r.getCostPrice());
                    }
                });
            }

        }

        return tempOrderVo;
    }

    public void genOrganizationSalesPrice(String organizationCode, TempOrderVo tempOrderVo) {
        long methodStartTime = System.currentTimeMillis();
        logs.info("### 开始为订单计算第三方费率价格 ... ###");
        /** 使用费率表计算第三方价格 */
        if (!Lang.isEmpty(organizationCode)) {
            long organizationTime = System.currentTimeMillis();
            String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
            logs.info("查询机构信息耗时 {} ms", System.currentTimeMillis() - organizationTime);

            if (organizationId != null) {
                List<SalesPriceCalVo> salesPriceCalVoList = new ArrayList<>();
                for (TempOrderStoreVo storeVo : tempOrderVo.getStoreList()) {
                    for (TempOrderItemVo itemVo : storeVo.getOrderItems()) {
                        salesPriceCalVoList.add(new SalesPriceCalVo(itemVo.getProductFashionId(), storeVo.getStoreId(),
                                storeVo.getCode(), organizationId, itemVo.getSalePrice(),
                                itemVo.getCostPrice(), itemVo.getMarketPrice(),
                                itemVo.getCostPrice(), itemVo.getCount(), organizationCode));
                    }
                }

                long calBatchSalesPriceTime = System.currentTimeMillis();
                List<Map> rateCalRs = salesPriceRateApi.calBatchSalesPrice(salesPriceCalVoList);
                logs.info("批量计算费率价格耗时 {} ms", System.currentTimeMillis() - calBatchSalesPriceTime);

                for (Map m : rateCalRs) {
                    for (TempOrderStoreVo storeVo : tempOrderVo.getStoreList()) {
                        for (TempOrderItemVo itemVo : storeVo.getOrderItems()) {
                            if (itemVo.getProductFashionId().equals(m.get("fashionId"))) {
                                itemVo.setSalePrice(((BigDecimal) m.get("salePrice")).setScale(2, BigDecimal.ROUND_UP));
                                itemVo.setSalesPriceRate((BigDecimal) m.get("rate"));
                                /** 回写费率计算后的销售价格 */
                                long activityIdTime = System.currentTimeMillis();
                                String activityId = activityGoodsApi.isInActivityNow(itemVo.getGoodsId(), organizationCode);
                                logs.info("获取商品活动场次信息耗时 {} ms", System.currentTimeMillis() - activityIdTime);
                                if (!Lang.isEmpty(activityId)) {
                                    // 获取活动价格
                                    itemVo.setActivityId(activityId);

                                    long activityPriceTime = System.currentTimeMillis();
                                    BigDecimal salePrice = activityGoodsApi.getActivityPrice(itemVo.getGoodsId(), organizationCode, storeVo.getCode()).setScale(2, BigDecimal.ROUND_UP);
                                    logs.info("获取活动价格耗时 {} ms", System.currentTimeMillis() - activityPriceTime);

                                    itemVo.setSalePrice(salePrice);
                                    logs.info("创建订单 - 活动商品ID {}, 活动场次ID {}, 活动价格 {}", itemVo.getGoodsId(), activityId, salePrice);
                                }

                                /*GoodsDto goods = goodsApi.findById(itemVo.getGoodsId());
                                activities.dto.goods.GoodsDto activitiesGoodDto = Lang.isEmpty(goods) ? null : mapperFacade.map(goods, activities.dto.goods.GoodsDto.class);

                                Map<String, Object> activityPriceMap = activityGoodsApi.isActivityGoodsAndGetActivityPrice(activitiesGoodDto, organizationCode);
                                Boolean isActivityGoods = (Boolean) activityPriceMap.get("isActivityGoods");
                                BigDecimal activityPrice = (BigDecimal) activityPriceMap.get("activityPrice");
                                if (isActivityGoods) {
                                    //活动商品走活动价
                                    String activityId = (String) activityPriceMap.get("activityId");
                                    ActivityDefinitionDto activity = activityApi.findById(activityId);
                                    Date now = new Date();

                                    //判断活动是否已经开始
                                    if (!Lang.isEmpty(activity.getBeginTime()) && now.after(activity.getBeginTime())) {
                                        itemVo.setActivityId((String) activityPriceMap.get("activityId"));
                                        itemVo.setSalePrice(activityPrice);
                                    }
                                }*/
                            }
                        }
                    }
                }
            }
        }
        logs.info("### 为订单计算第三方费率价格总耗时 {} ms", System.currentTimeMillis() - methodStartTime);
    }

    public TempOrderStoreVo generateStoreVo(StoreDto storeDto) {
        TempOrderStoreVo storeVo = new TempOrderStoreVo();
        storeVo.setStoreId(storeDto.getId());
        storeVo.setCode(storeDto.getStoreExt().getCode());
        storeVo.setDomain(storeDto.getStoreExt().getDomain());
        storeVo.setLogoImg(storeDto.getStoreExt().getLogoImg());
        storeVo.setStoreName(storeDto.getStoreExt().getStoreName());
        storeVo.setShortName(storeDto.getStoreExt().getShortName());
        storeVo.setStorePath(storeDto.getStoreExt().getStorePath());
        storeVo.setType(storeDto.getStoreExt().getType());
        storeVo.setSumPrice(BigDecimal.valueOf(0));
        storeVo.setSumMarketPrice(BigDecimal.valueOf(0));
        return storeVo;
    }

    //企业剩余积分是否足以扣除
    private Boolean isScoreEnough(OrganizationDto organization, BigDecimal totalScore) {
        Boolean isEnough = true;
        if (organization.getOrgScore().subtract(totalScore).compareTo(BigDecimal.ZERO) <= 0) {
            isEnough = false;
        }
        return isEnough;
    }

    private void updateOrganizationAccount(BigDecimal totalPrice, String type, OrganizationDto organization) {
        BigDecimal currentMoney = organization.getCurrentMoney();
        if ("add".equals(type)) {
            currentMoney = currentMoney.add(totalPrice);
        } else {
            currentMoney = currentMoney.subtract(totalPrice);
        }
        organization.setCurrentMoney(currentMoney);
        organizationApi.saveOrganization(organization);
    }

    private void updateOrganizationScore(BigDecimal totalScore, OrganizationDto organization) {
        BigDecimal currentScore = organization.getOrgScore();
        currentScore = currentScore.subtract(totalScore);
        organization.setOrgScore(currentScore);
        organizationApi.saveOrganization(organization);
    }

    private void generateCreditsHistory(Integer totalScore, MemberDto member, OrganizationDto organization) {
        OrganizationCreditsDto organizationCreditsDto = new OrganizationCreditsDto();
        organizationCreditsDto.setMemberId(member.getId());
        organizationCreditsDto.setUseScore(totalScore);
        organizationCreditsDto.setOrganization(organization);
        organizationCreditsDto.setRemark("用户：" + member.getCoreUser().getUsername() + "在" + DateUtils.getNowTime() + "消费了" + totalScore + "积分");
        organizationCreditsApi.saveOrganizationCredits(organizationCreditsDto);
    }

    private MemberCreditsTranDto genMemberCreditsTran(TempOrderStoreVo tempOrderStoreVo, MemberDto member, BigDecimal sumScore) {
        MemberCreditsTranDto tran = new MemberCreditsTranDto();
        tran.setUseScore(sumScore);
        tran.setSendName(member.getRealName());
        tran.setTargetMemberId(tempOrderStoreVo.getStoreId());
        tran.setTargetName(tempOrderStoreVo.getStoreName());
        tran.setSendUserId(member.getId());
        tran.setSendType("4");
        return tran;
    }

    private void genOrder(String addressId, MemberDto member, OrderMain order, TempOrderStoreVo tempOrderStoreVo, String invoiceId, String usageCode, TempOrderVo tempOrderVo) {
        MemberAddressDto address = memberAddressApi.findById(addressId);
        order.setAddressId(addressId);
        order.setMemberId(member.getId());
        order.setOrganizationId(member.getCoreUser().getOrganizationId());
        order.setSumPrice(tempOrderStoreVo.getSumPrice()); // 包含运费
        order.setSumNofreightPrice(tempOrderStoreVo.getSumPrice()); // 不包含运费
        order.setOrderItems(new ArrayList<>());

        // 回写购买人信息
        if (address != null) {
            order.setRecipientName(address.getUsername());
        }
//        order.setStatus(OrderMain.order_status_obligation);
        /** 如果是第三方商户，订单状态改为新建，占用库存成功后再回写为待付款 */
        HandlerRespVo<Boolean> respVo = outsideProductApi.isOutsideStore(tempOrderStoreVo.getStoreId());
        if (respVo.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS) && respVo.getData()) {
            order.setStatus(OrderMain.order_status_neworder);
        } else {
            order.setStatus(OrderMain.order_status_obligation);
        }
        order.setStoreId(tempOrderStoreVo.getStoreId());//店鋪id
        order.setCreateTime(new Date());//shijian
        order.setFreight(new BigDecimal(0));//运费默认0
        // 运费减免金额
        order.setFreeFreight(BigDecimal.ZERO);
        order.reCalSumPrice();
        order.setInvoiceId(invoiceId);
        order.setUsageCode(usageCode);
        if (order.getRealOrganizationId() == null) {
            order.setRealOrganizationId(order.getOrganizationId());
        }
        order.setStoreType(tempOrderStoreVo.getType());
        order.setStoreName(tempOrderStoreVo.getStoreName());
        order.setStoreCode(tempOrderStoreVo.getCode());
        /**
         * 保存orderMain的其他信息
         */
        saveOrderMainExtMessage(addressId, member, order, tempOrderStoreVo, invoiceId, usageCode, tempOrderVo);

    }


    private void saveOrderMainExtMessage(String addressId, MemberDto member, OrderMain order, TempOrderStoreVo tempOrderStoreVo, String invoiceId, String usageCode, TempOrderVo tempOrderVo) {
        /**
         * 设置浏览器信息
         * Roney add 20171016
         * start
         */
        order.setBuyType(tempOrderVo.getBuyType());
        order.setHeadMessage(tempOrderVo.getHeadMessage());
        order.setBrowserType(tempOrderVo.getBrowserType());
        order.setPlatformType(tempOrderVo.getPlatformType());

        /**
         * 设置浏览器信息
         * Roney add 20171016
         * end
         */
        order.setRequestId(tempOrderVo.getRequestId());
        logs.info("tempOrderVo.getRequestId{}", tempOrderVo.getRequestId());

        /**
         * 保存信息参数，直接将参数转成map保存
         * Roney add 20171126
         * start
         */
        Map postMap = new HashMap();
        postMap.put("tempOrderVo", tempOrderVo);
        postMap.put("addressId", addressId);
        postMap.put("invoiceId", invoiceId);
        postMap.put("usageCode", usageCode);
        order.setPostDesc(JSONObject.toJSONString(postMap));
        if (Lang.isEmpty(tempOrderVo.getRequestId())) {
            order.setRequestId(tempOrderVo.getTmpOrderNo());
        }
        /**
         * 保存信息参数，直接将参数转成map保存
         * Roney add 20171126
         * end
         */
    }

    private void genOrder(String addressId, MemberDto member, OrderMain order, TempOrderStoreVo tempOrderStoreVo, String invoiceId, TempOrderVo tempOrderVo) {
        genOrder(addressId, member, order, tempOrderStoreVo, invoiceId, null, tempOrderVo);
    }

    private void reduceStock(OrderMain order) {
        /** 减少库存 */
        ProductFashionDto pf;
        for (OrderItem it : order.getOrderItems()) {
            if (!Lang.isEmpty(it)) {
                pf = productFashionApi.findById(it.getProductFashId());
                if (!Lang.isEmpty(pf)) {
                    if (pf.getStockCount() > 0) {
                        pf.setStockCount(pf.getStockCount() - it.getCount());
                    }
                    productFashionApi.saveFashion(pf);
                }
            }
        }
    }

    /**
     * 生成订单详情
     *
     * @param order
     * @param tempOrderStoreVo
     * @return
     */
    private int genOrderItem(OrderMain order, TempOrderStoreVo tempOrderStoreVo) {
        int totalCounts = 0;
        OrderItem orderItem; /** 生成订单详情 */

        MemberAddressDto memberAddress = memberAddressApi.findById(order.getAddressId());
        FashionPriceRequestVo fashionPriceRequestVo = new FashionPriceRequestVo();
        fashionPriceRequestVo.setCityCode(memberAddress.getCityCode());
        fashionPriceRequestVo.setProvinceCode(memberAddress.getProvinceCode());
        fashionPriceRequestVo.setCountyCode(memberAddress.getAreaCode());
        fashionPriceRequestVo.setTownCode(memberAddress.getTownCode());
        fashionPriceRequestVo.setFashionPriceParamVos(new ArrayList<>());

        for (TempOrderItemVo c : tempOrderStoreVo.getOrderItems()) {
            FashionPriceParamVo fashionPriceParamVo = new FashionPriceParamVo();
            fashionPriceParamVo.setFactionId(c.getProductFashionId());
            fashionPriceParamVo.setProductCode(c.getProductCode());
            fashionPriceRequestVo.getFashionPriceParamVos().add(fashionPriceParamVo);
            totalCounts++;
            orderItem = generateOrderItem(c);

            // 处理子商品
            if (c.getChildren() != null && c.getChildren().size() > 0) {
                OrderItem childOrderItem;
                List<OrderItem> childOrderItemList = new ArrayList<>();
                for (TempOrderItemVo cc : c.getChildren()) {
                    childOrderItem = generateOrderItem(cc);
                    childOrderItem.setParent(orderItem);
                    childOrderItemList.add(childOrderItem);
                }
                orderItem.setChildren(childOrderItemList);
            }
            orderItem.setOrder(order);
            order.getOrderItems().add(orderItem);
        }

        /** 批量获取供应商售价 */

        String spiderLogFlag = systemConfigApi.getConfigValue(SystemConfigDto.ORG_CODE_COMMON, SystemConfigDto.CONFIG_CODE_ORDER_CONFIGS,
                "ORDER_SPIDER_PRICE_LOG", true, true, false
        );

        if (spiderLogFlag != null && "1".equals(spiderLogFlag)) {
            Long time = System.currentTimeMillis();
            HandlerRespVo<Map<String, BigDecimal>> apiRes = outsideProductApi.runPriceSpider(order.getStoreId(), fashionPriceRequestVo,
                    OutsideProductApi.SPIDER_TRIGGER_TYPE_ORDER, false);
            logs.info("orderItem批量获取供应商售价:{}ms", System.currentTimeMillis() - time);
            if (apiRes != null && apiRes.getStatus() != null && apiRes.getStatus() == HandlerRespVo.RESPONSE_STATUS_SUCCESS) {
                Map<String, BigDecimal> resData = apiRes.getData();
                /** 回写供应商售价 */
                for (TempOrderItemVo c : tempOrderStoreVo.getOrderItems()) {
                    for (OrderItem oi : order.getOrderItems()) {
                        if (oi.getProductFashId().equals(c.getProductFashionId())) {
                            oi.setTrdSalePrice(resData.get(c.getProductCode()));
                            break;
                        }
                    }
                }
            }
        }
        return totalCounts;
    }

    /**
     * 使用
     *
     * @param tempOrderItemVo
     * @return
     */
    private OrderItem generateOrderItem(TempOrderItemVo tempOrderItemVo) {
        OrderItem orderItem = new OrderItem();
        orderItem.setCount(tempOrderItemVo.getCount());
        orderItem.setProductName(tempOrderItemVo.getFashionTitle());//商品名称
        orderItem.setCostPrice(tempOrderItemVo.getCostPrice());
        orderItem.setSalePrice(tempOrderItemVo.getSalePrice());
        orderItem.setOrginSalePrice(tempOrderItemVo.getOrginSalePrice());
        orderItem.setProductPrice(tempOrderItemVo.getMarketPrice());
        orderItem.setMemberPrice(orderItem.getSalePrice());
        orderItem.setFinalPrice(tempOrderItemVo.getSalePrice());
        orderItem.setSeckillPrice(tempOrderItemVo.getSalePrice());
        orderItem.setActivityId(tempOrderItemVo.getActivityId());
        orderItem.setGoodsId(tempOrderItemVo.getGoodsId());
        orderItem.setProductFashId(tempOrderItemVo.getProductFashionId());
        orderItem.setProductId(tempOrderItemVo.getProductId());
        orderItem.setSku(tempOrderItemVo.getProductCode());
        orderItem.setSalePriceRate(tempOrderItemVo.getSalesPriceRate());
        orderItem.setProductType(tempOrderItemVo.getProductType());
        orderItem.setProductPic(tempOrderItemVo.getFashionPic());
        orderItem.setBusinessCode(tempOrderItemVo.getBusinessCode());
        return orderItem;
    }

    /**
     * 查询运费（订单）
     *
     * @param storeId:    String
     * @param orderItems: List<CartItemVo>
     * @param addressId:  MemberAddress 表 ID /可传areaCode addressCommonApi.areaCodeNodeList
     * @param useCache
     * @return
     */
    public sinomall.global.common.response.BaseResponse<BigDecimal> queryShippingFee(String storeId, List<TempOrderItemVo> orderItems, String addressId, Boolean useCache) {
        long methodStartTime = System.currentTimeMillis();
        logs.info("### 开始查询订单运费 ... ###");
        BigDecimal shippingFee = null;
        if (useCache) {
            shippingFee = getShippingFeeInCache(storeId, orderItems);
        }
        sinomall.global.common.response.BaseResponse<BigDecimal> baseResponse = new sinomall.global.common.response.BaseResponse<>(false, "获取运费失败");
        if (useCache && shippingFee != null) {
            logs.info("使用缓存运费, shippingFee: {}", shippingFee);
            logs.info("### 查询订单运费总耗时 {} ms", System.currentTimeMillis() - methodStartTime);

            return new sinomall.global.common.response.BaseResponse<BigDecimal>(true, "获取运费成功", shippingFee);

        } else {
            long addressTime = System.currentTimeMillis();
            MemberAddressDto address = memberAddressApi.findById(addressId);
            logs.info("查询地址耗时 {} ms", System.currentTimeMillis() - addressTime);

            Map<Integer, String> areaNodeMap = null;
            if (address == null || Lang.isEmpty(address.getId())) {
                long areaNodeMapTime = System.currentTimeMillis();
                areaNodeMap = addressCommonApi.areaCodeNodeList(addressId);
                logs.info("查询区域代码耗时 {} ms", System.currentTimeMillis() - areaNodeMapTime);
            }
            if (!Lang.isEmpty(storeId) && (!Lang.isEmpty(address) || !Lang.isEmpty(areaNodeMap))) {
                long checkStoreTime = System.currentTimeMillis();
                HandlerRespVo<Boolean> checkStoreRes = outsideProductApi.isOutsideStore(storeId);
                logs.info("检查店铺耗时 {} ms", System.currentTimeMillis() - checkStoreTime);
                if (checkStoreRes != null && checkStoreRes.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS) && checkStoreRes.getData() != false) {
                    ShippingFeeRequetVo shippingFeeRequetVo = new ShippingFeeRequetVo();
                    List<FashionNumsVo> fashionNums = new ArrayList<>();
                    FashionNumsVo fashionNumsVo;
                    for (TempOrderItemVo itemVo : orderItems) {
                        fashionNumsVo = new FashionNumsVo(
                                itemVo.getProductFashionId(),
                                itemVo.getProductCode(),
                                new Long(itemVo.getCount())
                        );
                        fashionNums.add(fashionNumsVo);
                    }
                    shippingFeeRequetVo.setFashionNums(fashionNums);
                    if (address != null && !Lang.isEmpty(address.getId())) {
                        shippingFeeRequetVo.setProvinceCode(address.getProvinceCode());
                        shippingFeeRequetVo.setCityCode(address.getCityCode());
                        shippingFeeRequetVo.setCountyCode(address.getAreaCode());
                        shippingFeeRequetVo.setTownCode(address.getTownCode());
                    } else {
                        shippingFeeRequetVo.setProvinceCode(areaNodeMap.get(1));
                        shippingFeeRequetVo.setCityCode(areaNodeMap.get(2));
                        shippingFeeRequetVo.setCountyCode(areaNodeMap.get(3));
                        shippingFeeRequetVo.setTownCode(areaNodeMap.get(4));
                    }

                    shippingFeeRequetVo.setAddrDetail(address.getAddressDetail());

                    long queryShippingFeeTime = System.currentTimeMillis();
                    HandlerRespVo<Map<String, Object>> res = outsideProductApi.queryShippingFee(storeId, shippingFeeRequetVo);
                    logs.info("第三方接口获取运费耗时 {} ms", System.currentTimeMillis() - queryShippingFeeTime);

                    if (res.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS)) {
                        logs.info("### 查询订单运费总耗时 {} ms", System.currentTimeMillis() - methodStartTime);
                        BigDecimal freight = (BigDecimal) res.getData().get("freight");
                        if (freight != null) {
                            setShippingFeeCache(storeId, orderItems, freight);
                        } else {
                            return new sinomall.global.common.response.BaseResponse<BigDecimal>(true, "获取运费成功", new BigDecimal(0));
                        }
                        return new sinomall.global.common.response.BaseResponse<BigDecimal>(true, "获取运费成功", freight);

                    }
                    baseResponse.setResultMessage(res.getMessage());
                } else {
                    //TODO: 集采商品配送费用计算 @LWX
                    logs.info("### 查询订单运费总耗时 {} ms", System.currentTimeMillis() - methodStartTime);
                    return new sinomall.global.common.response.BaseResponse<BigDecimal>(true, "获取运费成功", new BigDecimal(0));

                }

            }
            logs.info("### 查询订单运费总耗时 {} ms", System.currentTimeMillis() - methodStartTime);

        }
        return baseResponse;

    }

    /**
     * 查询运费（购物车）
     *
     * @param storeId:   String
     * @param cartItems: List<CartItemVo>
     * @param addressId: MemberAddress 表 ID
     * @return
     */
    public BigDecimal queryCartShippingFee(String storeId, List<CartItemVo> cartItems, String addressId) {
        MemberAddressDto address = memberAddressApi.findById(addressId);
        Map<Integer, String> areaNodeMap = null;
        if (address == null || Lang.isEmpty(address.getId())) {
            areaNodeMap = addressCommonApi.areaCodeNodeList(addressId);
        }
        if (!Lang.isEmpty(storeId) && (!Lang.isEmpty(address) || !Lang.isEmpty(areaNodeMap))) {
//            Store store = storeApi.getStoreInfo(storeId);
            HandlerRespVo<Boolean> checkStoreRes = outsideProductApi.isOutsideStore(storeId);
            if (checkStoreRes != null && checkStoreRes.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS) && checkStoreRes.getData() != false) {
                ShippingFeeRequetVo shippingFeeRequetVo = new ShippingFeeRequetVo();
                List<FashionNumsVo> fashionNums = new ArrayList<>();
                FashionNumsVo fashionNumsVo;
                for (CartItemVo itemVo : cartItems) {
                    fashionNumsVo = new FashionNumsVo(
                            itemVo.getProductFashId(),
                            itemVo.getProduct().getCode(),
                            new Long(itemVo.getCount())
                    );
                    fashionNums.add(fashionNumsVo);
                }
                shippingFeeRequetVo.setFashionNums(fashionNums);
                if (address != null && !Lang.isEmpty(address.getId())) {
                    shippingFeeRequetVo.setProvinceCode(address.getProvinceCode());
                    shippingFeeRequetVo.setCityCode(address.getCityCode());
                    shippingFeeRequetVo.setCountyCode(address.getAreaCode());
                    shippingFeeRequetVo.setTownCode(address.getTownCode());
                } else if (areaNodeMap != null) {
                    shippingFeeRequetVo.setProvinceCode(areaNodeMap.get(1));
                    shippingFeeRequetVo.setCityCode(areaNodeMap.get(2));
                    shippingFeeRequetVo.setCountyCode(areaNodeMap.get(3));
                    shippingFeeRequetVo.setTownCode(areaNodeMap.get(4));
                }
                HandlerRespVo<Map<String, Object>> res = outsideProductApi.queryShippingFee(storeId, shippingFeeRequetVo);
                if (res.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS)) {
                    return (BigDecimal) res.getData().get("freight");
                }
            } else {
                //TODO: 集采商品配送费用计算 @LWX
                return new BigDecimal(0);
            }

        }
        return null;
    }

    /**
     * 运费计算
     *
     * @param orderMain
     * @param params
     */
    public void reCalFreight(OrderMain orderMain, TempOrderStoreVo storeVo, String memberAddressId, Boolean useCache, Map params) {
        /** 运费计算 */
        BigDecimal freight;
        try {
            freight = queryShippingFee(storeVo.getStoreId(), storeVo.getOrderItems(), memberAddressId, useCache == null ? false : useCache).getResult();
        } catch (Exception E) {
            freight = BigDecimal.ZERO;
        }
        orderMain.setFreight(freight);
        //TODO: 免运费规则，后续再此添加
        if (!Lang.isEmpty(params) && (Boolean) params.get("isFreeFreight")) {
            orderMain.setFreeFreight(freight);
        } else {
            orderMain.setFreeFreight(BigDecimal.ZERO);
        }
        orderMain.reCalSumPrice();
    }

    //更新商品出售数量
    @Transactional(readOnly = false, propagation = Propagation.REQUIRES_NEW)
    public void updateGoodsSaleCount(String status, String orderNo) {
        try {
            String countGoodsSaleSql = "select sum(ot.count) from order_item  ot ,order_main om where ot.goods_id=? and om.status in(1,2,3,4,5,7) and om.id=ot.order_id ";
            //更新商品的数量
            OrderMain orderMain = orderRepos.findByOrderNo(orderNo);
            if (!Lang.isEmpty(orderMain.getOrderItems())) {
                for (OrderItem item : orderMain.getOrderItems()) {
                    Integer saleCount = (Integer) jdbcTemplate.queryForObject(countGoodsSaleSql, new Object[]{item.getGoodsId()}, Integer.class);
                    if (Lang.isEmpty(saleCount)) {
                        saleCount = 0;
                    }
                    goodsApi.updateGoodsSaleCount(item.getGoodsId(), saleCount.longValue());
                   /* GoodsDto goodsDto = goodsApi.findById(item.getGoodsId());
                    if (!Lang.isEmpty(goodsDto)) {
                        //goodsDto.setSaleCount(saleCount.longValue());
                        goodsApi.updateGoodsSaleCount(goodsDto.getId(), saleCount.longValue());
                    }*/
                }
            }
        } catch (Exception e) {
            logs.error("更新goods销售量出错", e);
        }
        /*for (OrderItem orderItem : orderMain.getOrderItems()) {
            if (orderItem.getActivityId() != null) { //活动商品减库存
                activityGoodsApi.increamentSaleCount(orderItem.getActivityId(), orderItem.getGoodsId(), orderItem.getCount());
            }
        }*/


    }

//    /**
//     * 订单审核通过推送消息
//     *
//     * @param orderMain
//     * @return
//     */
//    public OrderMain orderPassed(OrderMain orderMain) {
//        OrderMainDto orderMainDto = mapperFacade.map(orderMain, OrderMainDto.class);
//        orderMainApi.triggerEvent(orderMain.getOrderNo(), OrderMainApiImpl.ORDER_EVENT_PASSED);
//
//        return mapperFacade.map(orderMainDto, OrderMain.class);
//    }

//    public ApiResponseVo comfirmBatchDeliver(BatchDeliverOrderVo request) {
//        ApiResponseVo<BatchDeliverOrderRespVo> apiResponseVo = new ApiResponseVo<>();
//        try {
//            if (Lang.isEmpty(request)) {
//                return ApiResponseVo.createErrorResp("确认收货失败，参数信息为空", "1", null);
//            } else {
//                List<String> orderIds = request.getOrderIds();
//                List<String> orderNos = request.getOrderNos();
//                if (Lang.isEmpty(orderIds) && Lang.isEmpty(orderNos)) {
//                    apiResponseVo.setStatus(GlobalContants.ResponseStatus.ERROR);
//                    apiResponseVo.setCode(GlobalContants.MISS_PARAMS);
//                    apiResponseVo.setMessage("订单号和订单ID不能同时为空");
//
//                } else {
//                    apiResponseVo.setStatus(GlobalContants.ResponseStatus.SUCCESS);
//                    apiResponseVo.setMessage("确认收货成功");
//                    apiResponseVo.setCode(GlobalContants.REQUERST_SUCCESS);
//                    List<String> updateOrderIds = null;
//                    if (!Lang.isEmpty(orderNos)) {//订单号，需要查询
//                        updateOrderIds = new ArrayList<>();
//                        List<OrderMain> orderMainList = orderRepos.findByOrderNoIn(orderNos);
//                        for (OrderMain orderMain : orderMainList) {
//                            updateOrderIds.add(orderMain.getId());
//                        }
//                    } else if (!Lang.isEmpty(orderIds)) {
//                        updateOrderIds = orderIds;
//                    }
//
//                    int resultOrderSize = orderRepos.batchUpdateStatusByIds(OrderMain.order_status_evaluate, updateOrderIds, new Date(), true);
//                    int resultSubOrderSize = subOrderRepos.batchUpdateSubOrderStatusByOrderIds(SubOrder.TRD_SP_HAS_BEEN_PUT, updateOrderIds, new Date(), SubOrder.TRD_SP_HAS_BEEN_PUT);
//                    BatchDeliverOrderRespVo batchDeliverOrderRespVo = new BatchDeliverOrderRespVo();
//                    List<OrderMain> orderMainList = orderRepos.findByIdIn(updateOrderIds);
//                    orderMainList.forEach(o -> orderMainApi.triggerEvent(o.getOrderNo(), OrderMainApiImpl.ORDER_EVENT_SHIPPING_COMFIRMED));
//                    batchDeliverOrderRespVo.setResOrderList(mapperFacade.mapAsList(orderMainList, OrderMainDto.class));
//                    apiResponseVo.setData(batchDeliverOrderRespVo);
//                }
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            apiResponseVo.setMessage("系统服务异常");
//            apiResponseVo.setCode(GlobalContants.SYSTEM_SERVER_ERROR);
//        }
//        return apiResponseVo;
//    }

    /**
     * 查询待开发票的订单数据（Sql实现）
     *
     * @param storeId
     * @param orderNo
     * @param orgId
     * @param payMethod
     * @param orderStatus
     * @param invoiceStatus    发票状态
     * @param createTimeLower
     * @param createTimeHigher
     * @param fields           // 指定标量查询，依次传入查询的字段，字段名： ORDER_MAIN o, PAYMENT payment , payment_config payment_config, STORE sotre, ORGANIZATION organization, Member_In_Voice member_invoice, sp_invoice_info invoice
     * @param pageable
     * @return
     */
    public Page<Map<String, Object>> queryForInvoicePrint(String companyCodeTpds, String storeId, String orderNo, String compName,
                                                          String payMethod, List<String> orderStatus, List<String> invoiceStatus,
                                                          Date createTimeLower, Date createTimeHigher, String orgId, List<String> fields, String invoiceType, Pageable pageable) {

        String orderSelects = "o.*";
        List<String> queryFields = new ArrayList<>();
        List<String> fieldNames = new ArrayList<>();
        if (!Lang.isEmpty(fields)) {
            for (String f : fields) {
                if ("invoice_money".equals(f)) { // 订单开具发票的价税合计（订单总价）
                    queryFields.add(" (SELECT SUM(i.money) from sp_invoice_info i WHERE i.member_invoice_id = member_invoice.id and i.is_delete = 0 ) as invoice_money ");
                } else if ("invoice_tax".equals(f)) { // 订单开具发票的总税额
                    queryFields.add(" (SELECT SUM(i.tax) from sp_invoice_info i WHERE i.member_invoice_id = member_invoice.id and i.is_delete = 0 ) as invoice_tax ");
                } else if ("invoice_no_tax_price".equals(f)) { // 订单开具发票的不含税合计
                    queryFields.add(" (SELECT SUM(i.money) - SUM(i.tax) from sp_invoice_info i WHERE i.order_id = o.id and i.is_delete = 0 ) as invoice_no_tax_price ");
                } else if ("invoice_tax_rate".equals(f)) { // 订单开具发票的合计税率
                    queryFields.add(" (SELECT SUM(i.tax) / (SUM(i.money) - SUM(i.tax)) from sp_invoice_info i WHERE i.order_id = o.id and i.is_delete = 0 ) as invoice_tax_rate ");
                } else if (!f.contains(".")) {
                    queryFields.add("o." + f);
                } else {
                    queryFields.add(f);
                }
                fieldNames.add(f);
            }

            orderSelects = Joiner.on(",").skipNulls().join(queryFields);
            /** order之外的固定字段 */
            fieldNames.add("pay_method_name");
            fieldNames.add("store_name");
            fieldNames.add("org_name");
            fieldNames.add("item_counts");
            fieldNames.add("invoice_type");
        }


        /** 数据查询Sql */
        StringBuilder sql = new StringBuilder().append("SELECT ").append(orderSelects)
                .append(" , payment_config.name AS pay_method_name, (SELECT store_ext.store_name FROM store_ext store_ext WHERE store_ext.store_id = sotre.id) AS store_name, organization.org_name ")
                .append(" , (SELECT COUNT(0) from ORDER_ITEM item WHERE item.order_id = o.id) AS item_counts")
                .append(" ,  member_invoice.type AS invoice_type");
        /** 数据总量统计sql */
        StringBuilder countSql = new StringBuilder().append("SELECT COUNT(0) ");

        StringBuilder where = new StringBuilder().append(" FROM ORDER_MAIN o, PAYMENT payment , PAYMENT_CONFIG payment_config, STORE sotre, ORGANIZATION organization, MEMBER_IN_VOICE member_invoice ")
                .append("WHERE payment.id = o.payment_id AND payment_config.id = payment.payment_mode_id AND sotre.id = o.store_id  AND (member_invoice.id = o.invoice_id or member_invoice.order_no = o.order_no) AND organization.id = o.organization_id ");

        List<Object> arrs = new ArrayList<>();
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        /** 处理发票信息表的子查询 */
        StringBuilder invoiceInfoSubQuery = new StringBuilder();
        invoiceInfoSubQuery.append(" AND (SELECT COUNT(0) from sp_invoice_info i WHERE i.order_id = o.id AND i.can_invoice_time <= ?1 AND i.is_delete != 1");
        arrs.add(new Date());

//        if (!Lang.isEmpty(invoiceStatus)) {
//            arrs.add(invoiceStatus);
//            invoiceInfoSubQuery.append(" AND i.status in ?").append(arrs.size()).append(" ");
//        }

        if (!Lang.isEmpty(compName)) {
            arrs.add("%" + compName + "%");
            invoiceInfoSubQuery.append(" AND i.name like ?").append(arrs.size()).append(" ");

        }

        invoiceInfoSubQuery.append(") > 0 ");
        where.append(invoiceInfoSubQuery);
        /** 处理订单表的查询 */

        // 发票状态查询
        if (!Lang.isEmpty(invoiceStatus)) {
            arrs.add(invoiceStatus);
            where.append(" AND (select count(0) from sp_invoice_info i where i.MEMBER_INVOICE_ID = member_invoice.id AND i.status in ?").append(arrs.size()).append(" ) > 0 ");
        }

        if (!Lang.isEmpty(storeId)) {
            arrs.add(storeId);
            where.append(" AND o.store_id=?" + arrs.size());
        }

        if (!Lang.isEmpty(orderNo)) {
            arrs.add("%" + orderNo + "%");
            where.append(" AND o.order_No like ?" + arrs.size());
        }

        if (!Lang.isEmpty(orgId)) {
            arrs.add(orgId);
            where.append(" AND o.organization_id=?" + arrs.size());
        }

        if (!Lang.isEmpty(payMethod)) {
            arrs.add(payMethod);
            where.append(" AND payment_config.id=?" + arrs.size());
        }

        if (!Lang.isEmpty(createTimeLower)) {
            arrs.add(createTimeLower);
            where.append(" AND o.date_created >= ?" + arrs.size());
        }
        if (!Lang.isEmpty(createTimeHigher)) {
            arrs.add(createTimeHigher);
            where.append(" AND o.date_created < ?" + arrs.size());
        }
        if (!Lang.isEmpty(orderStatus)) {
            arrs.add(orderStatus);
            where.append(" AND o.status in ?" + arrs.size());
        }
        //协议订单不能打印发票
        String storeType = OrderMain.STORE_TYPE_PROTOCOL;
        if (!Lang.isEmpty(storeType)) {
            arrs.add(storeType);
            where.append(" AND o.store_type <> ?" + arrs.size());
        }
        if (!Lang.isEmpty(invoiceType)) {
            arrs.add(invoiceType);
            where.append(" AND (select count(0) from sp_invoice_info i where i.MEMBER_INVOICE_ID = member_invoice.id AND i.type in ?").append(arrs.size()).append(" ) > 0 ");
        }
        if (!Lang.isEmpty(companyCodeTpds)) {
            arrs.add(companyCodeTpds);
            where.append(" and o.company_id not in (select id from core_company  where code = ?" + +arrs.size() + ") ");
        }
        /**
         * Roney add 2017-11-25
         * 如果发票类型为空，不能进入打印发票列表
         */
        where.append(" AND (select count(0) from sp_invoice_info i where i.MEMBER_INVOICE_ID = member_invoice.id AND i.type is not null )>0 ");
        /**
         * Roney add 2017-11-25
         * 如果发票类型为空，不能进入打印发票列表
         */
        countSql.append(where);
        sql.append(where);
        sql.append(" order by o.order_no asc, o.date_created asc");
        logs.info("countSql:{}", countSql.toString());
        logs.info("sql:{}", sql.toString());
        javax.persistence.Query totalCountQuery = entityManager.createNativeQuery(countSql.toString());
        javax.persistence.Query dataQuery = entityManager.createNativeQuery(sql.toString());

        for (int i = 0; i < arrs.size(); i++) {
            totalCountQuery.setParameter(i + 1, arrs.get(i));
            dataQuery.setParameter(i + 1, arrs.get(i));
        }

        List<BigDecimal> countRs = totalCountQuery.getResultList();
        Integer total = 0;
        if (!Lang.isEmpty(countRs) && !Lang.isEmpty(countRs.get(0))) {
            total = countRs.get(0).intValue();
        }
        // 判断分页
        if (pageable != null && pageable.getOffset() < total && pageable.getPageSize() > 0) {
            dataQuery.setFirstResult(pageable.getOffset());
            dataQuery.setMaxResults(pageable.getPageSize());
        }

        List<Object[]> resultList = dataQuery.getResultList();

        List<Map<String, Object>> returnList = new ArrayList<>();
        Map<String, Object> tempMap;
        if (Lang.isEmpty(fields)) {
            for (Object[] objects : resultList) {
                tempMap = new HashMap<>();
                for (int i = 0; i < objects.length; i++) {
                    tempMap.put("" + i, objects[i]);
                }
                returnList.add(tempMap);
            }
        } else {
            for (Object[] objects : resultList) {
                tempMap = new HashMap<>();
                for (int i = 0; i < fieldNames.size(); i++) {
                    tempMap.put(fieldNames.get(i), objects[i]);
                }
                returnList.add(tempMap);
            }
        }

        PageImpl<Map<String, Object>> page = new PageImpl(returnList, pageable, total);


        return page;
    }


    public List<Map<String, Object>> findSubOrderItemBySubOrderNo(String subOrderNo) {
        String sql = "select so.sub_order_no,g.sku,g.sku,g.name,oi.cost_price,oi.count\n" +
                "  from sub_order so, sub_order_item soi, goods g, order_item oi\n" +
                " where so.id = soi.sub_order_id\n" +
                "   and soi.order_item_id = oi.id\n" +
                "   and oi.goods_id = g.id\n" +
                "   and so.sub_order_no = ? ";
        return jdbcTemplate.queryForList(sql, subOrderNo);
    }


    /**
     * 将DO转换成DTO
     *
     * @param orderMain 订单实体
     * @return
     */
    public OrderMainDto transToDto(OrderMain orderMain) {
        if (orderMain == null) {
            return null;
        }
        OrderMainDto dto = mapperFacade.map(orderMain, OrderMainDto.class);
        // 处理关联商品的orderItem
//        buildOrderItemRelations(dto);
//        filterMerchandise(Arrays.asList(dto));
        return dto;
    }

    /**
     * 将DO转换成DTO（批量）
     *
     * @param orderMains 订单实体列表
     * @return
     */
    public List<OrderMainDto> transToDto(List<OrderMain> orderMains) {
        if (orderMains == null || orderMains.size() <= 0) {
            return null;
        }
        List<OrderMainDto> dtos = mapperFacade.mapAsList(orderMains, OrderMainDto.class);
        // 处理关联商品的orderItem
//        buildOrderItemRelations(dtos);
//        filterMerchandise(dtos);
        return dtos;
    }

    public void filterMerchandise(List<OrderMainDto> dtos) {
        dtos.forEach(orderMainDto -> {
                    List<OrderItemDto> orderItems = orderMainDto.getOrderItems();
                    List<OrderItemDto> merchandiseOrderItems = orderItems.stream().filter(orderItemDto -> OrderItem
                            .PRODUCT_TYPE_MERCHANDISE.equals(orderItemDto
                                    .getProductType())).collect(Collectors.toList());
                    orderMainDto.setOrderItems(merchandiseOrderItems);
                }
        );
    }

    /**
     * 构建订单Item的从属关联
     *
     * @param orderMainDtoList 订单DTO列表
     * @return
     */
    public List<OrderMainDto> buildOrderItemRelations(List<OrderMainDto> orderMainDtoList) {
        List<String> orderItemParentIds = new ArrayList<>();
        List<OrderItemDto> allItems = new ArrayList<>();
        for (OrderMainDto omd : orderMainDtoList) {
            for (OrderItemDto oid : omd.getOrderItems()) {
                allItems.add(oid); // 先取出全部的itemDto，方便后续处理
                if (OrderItemDto.PRODUCT_TYPE_MERCHANDISE.equals(oid.getProductType())) {
                    orderItemParentIds.add(oid.getId());
                }
            }
        }

        // 查询item的关联
        List<OrderItemRelations> orderItemRelations = orderItemRelationsRepos.findAll((root, query, cb) -> {
            List<Predicate> andQuerys = new ArrayList<>();
            List<Predicate> pidOrQuerys = new ArrayList<>();
            for (String pItemId : orderItemParentIds) {
                pidOrQuerys.add(cb.equal(root.get("parentId"), pItemId));
            }

            if (pidOrQuerys.size() > 0) {
                andQuerys.add(cb.or(pidOrQuerys.toArray(new Predicate[0])));
            }

            andQuerys.add(cb.or(
                    cb.equal(root.get("type"), OrderItemRelations.PROD_RELATE_TYPE_SUBORDINATE)
            ));

            return cb.and(andQuerys.toArray(new Predicate[0]));
        });

        // 整理Item的关联
        if (orderItemRelations != null && orderItemRelations.size() > 0) {
            Map<String, List<OrderItemDto>> orderItemRelateMap = new HashMap<>();
            List<OrderItemDto> tmpOrderItemDtos = null;
            for (OrderItemRelations r : orderItemRelations) {
                tmpOrderItemDtos = orderItemRelateMap.get(r.getParentId());
                if (tmpOrderItemDtos == null) {
                    tmpOrderItemDtos = new ArrayList<>();
                }

                tmpOrderItemDtos.add(Lang.findInBeanList(allItems, "id", r.getChildId()));
                orderItemRelateMap.put(r.getParentId(), tmpOrderItemDtos);
            }

            // 修改OrderMain关联
            for (OrderMainDto omd : orderMainDtoList) {
                for (OrderItemDto oid : omd.getOrderItems()) {
                    if (OrderItemDto.PRODUCT_TYPE_MERCHANDISE.equals(oid.getProductType())) {
                        tmpOrderItemDtos = orderItemRelateMap.get(oid.getId());
                        oid.setChildren(tmpOrderItemDtos);
                    }
                }
            }
        }

        return orderMainDtoList;
    }

    /**
     * 构建订单Item的从属关联
     *
     * @param orderMainDto 订单DTO
     * @return
     */
    public OrderMainDto buildOrderItemRelations(OrderMainDto orderMainDto) {

        List<OrderMainDto> orderMainDtos = buildOrderItemRelations(Arrays.asList(new OrderMainDto[]{orderMainDto}));
        if (orderMainDtos != null && orderMainDtos.size() > 0) {
            return orderMainDtos.get(0);
        }

        return null;
    }

    /**
     * 修改订单的提交审核标志
     *
     * @param orderId   订单ID
     * @param auditFlag 审核标志，为false时不提交审核
     */
    @Transactional(readOnly = false)
    public void changeAuditFlag(String orderId, Boolean auditFlag) {
        OrderMain orderMain = orderRepos.getOne(orderId);
        if (orderMain != null) {
            orderMain.setAuditFlag(auditFlag);
            orderRepos.save(orderMain);
        }
    }

    public List<OrderMain> findAll(OrderMain orderMainSpec, OrderMainExt orderMainExt) {
        Specification specification = getSpecification(orderMainSpec, orderMainExt);
        return orderRepos.findAll(specification);
    }

    public Page<OrderMain> findAll(OrderMain orderMainSpec, OrderMainExt orderMainExt, Pageable pageable) {
        Specification specification = getSpecification(orderMainSpec, orderMainExt);
        return orderRepos.findAll(specification, pageable);
    }

    private Specification getSpecification(OrderMain orderMain, OrderMainExt orderMainExt) {
        return (Specification<OrderMain>) (root, criteriaQuery, criteriaBuilder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (!Lang.isEmpty(orderMain.getMemberId())) {
                predicates.add(criteriaBuilder.equal(root.get("memberId"), orderMain.getMemberId()));
            }
            if (!Lang.isEmpty(orderMain.getStatus())) {
                predicates.add(criteriaBuilder.equal(root.get("status"), orderMain.getStatus()));
            } else {
                predicates.add(criteriaBuilder.notEqual(root.get("status"), OrderMainDto.order_status_neworder));
                predicates.add(criteriaBuilder.notEqual(root.get("status"), OrderMainDto.order_status_error));
            }
            if (!Lang.isEmpty(orderMain.getOrderNo())) {
                predicates.add(criteriaBuilder.equal(root.get("orderNo"), orderMain.getOrderNo()));
            }
            if (!Lang.isEmpty(orderMain.getStoreType())) {
                predicates.add(criteriaBuilder.equal(root.get("storeType"), orderMain.getStoreType()));
            }
            if (orderMain.getIsDelete() != null) {
                predicates.add(criteriaBuilder.equal(root.get("isDelete"), orderMain.getIsDelete()));
            }
            //id
            if (!Lang.isEmpty(orderMain.getId())) {
                predicates.add(criteriaBuilder.equal(root.get("id"), orderMain.getId()));
            }
            if (!Lang.isEmpty(orderMain.getHaveReview())) {
                predicates.add(criteriaBuilder.equal(root.get("haveReview"), orderMain.getHaveReview()));
            }
            if (!Lang.isEmpty(orderMainExt)) {
                // createTime >= createTimeLowerBound
                if (!Lang.isEmpty(orderMainExt.getCreateTimeLowerBound())) {
                    predicates.add(criteriaBuilder.greaterThanOrEqualTo(root.<Date>get("createTime"), orderMainExt
                            .getCreateTimeLowerBound()));
                }
                // createTime <= createTimeUpBound
                if (!Lang.isEmpty(orderMainExt.getCreateTimeUpBound())) {
                    predicates.add(criteriaBuilder.lessThanOrEqualTo(root.<Date>get("createTime"), orderMainExt.getCreateTimeUpBound()));
                }
            }
            if (!Lang.isEmpty(orderMain.getHaveReview())) {
                predicates.add(criteriaBuilder.equal(root.get("haveReview"), orderMain.getHaveReview()));
            }
            //更多条件，依次累加
            return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
        };
    }


    public Long countByRequerstId(String requerstId) {
        return orderRepos.countByRequestId(requerstId);
    }

    /**
     * 判断requestId是否已下单成功
     *
     * @param requestId
     * @return
     */
    public Boolean checkSuccessedByRequestId(String requestId) {
        // 查询指定的requestId有无生未删除、不是取消状态的订单，如有则视为已下单成功
        Long counts = orderRepos.count((root, query, cb) -> cb.and(
                cb.equal(root.get("requestId"), requestId),
                cb.notEqual(root.get("isDelete"), true),
                cb.notEqual(root.get("status"), OrderMain.order_status_cancel)
        ));

        return counts > 0;
    }

    public Long countOrder(String memberId, List<String> status, boolean isDelete) {
        return orderRepos.countByMemberIdAndStatusInAndIsDelete(memberId, status, isDelete);
    }

    public void updateOrderFirstAuditTime(String orderId) {
        orderRepos.updateOrderFirstAuditTime(new Date(), orderId);
    }

    public void updateOrderAuditEndTime(String orderId) {
        orderRepos.updateOrderAuditEndTime(new Date(), orderId);
    }

    public Long countOrderNotCommemted(String memberId, List<String> status, boolean isDelete, boolean haveReview) {
        return orderRepos.countByMemberIdAndStatusInAndIsDeleteAndHaveReviewNot(memberId, status, isDelete, haveReview);
    }

    public OrderMain findByOrderNoAndMemberId(String orderNo, String memberId) {
        return orderRepos.findByOrderNoAndMemberId(orderNo, memberId);
    }

    public OrderMain findByOrderNo(String orderNo) {
        return orderRepos.findByOrderNo(orderNo);
    }

    public List<OrderItem> findByOrderId(String orderId) {
        return orderItemRepos.findByOrderId(orderId);
    }

    public List<OrderItem> findByOrderIdAndIsDiscussOrIsDiscussIsNull(String id, Boolean isDelete) {
        return orderItemRepos.findByOrderIdAndIsDiscussOrIsDiscussIsNull(id, isDelete);
    }

    public void saveAndFlush(OrderMain orderMain) {
        orderRepos.saveAndFlush(orderMain);
    }

    public OrderMain findByOrderNoAndStatusIn(String orderNo, List<String> status) {
        return orderRepos.findByOrderNoAndStatusIn(orderNo, status);
    }

    public List<OrderMainDto> findByOrderNos(List<String> orderNos) {
        List<OrderMain> orderMains = orderRepos.findByOrderNoIn(orderNos);
        List<OrderMainDto> orderMainDtos = BeanMapper.mapList(orderMains, OrderMain.class, OrderMainDto.class);
        return orderMainDtos;
    }

    public List<OrderMainDto> findByStatusAndShippingComfirmTimeIsNull(String status) {
        List<OrderMain> orderMains = orderRepos.findByStatusAndShippingComfirmTimeIsNull(status);
        List<OrderMainDto> orderMainDtos = BeanMapper.mapList(orderMains, OrderMain.class, OrderMainDto.class);
        return orderMainDtos;
    }

    public List<OrderMainDto> findByOrganizationIdAndAuditEndTimeIsNotNullAndBillsCreated(String organizationId, boolean billsCreated) {
        List<OrderMain> orderMains = orderRepos.findByOrganizationIdAndAuditEndTimeIsNotNullAndBillsCreated(organizationId, billsCreated);
        List<OrderMainDto> orderMainDtos = BeanMapper.mapList(orderMains, OrderMain.class, OrderMainDto.class);
        return orderMainDtos;
    }

    /**
     * 获取缓存运费
     *
     * @param storeId    店铺ID
     * @param orderItems 订单items
     * @return
     */
    private BigDecimal getShippingFeeInCache(String storeId, List<TempOrderItemVo> orderItems) {
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(storeId).append("_").append(
                Joiner.on("_").join(orderItems.stream().map(tempOrderItemVo -> String.format("%s_%s", tempOrderItemVo.getProductCode(), tempOrderItemVo.getCount())).collect(Collectors.toList()))
        );
        return shippingFeeOps.get(cacheKey.toString());
    }

    /**
     * 更新缓存运费
     *
     * @param storeId    店铺ID
     * @param orderItems 订单Items
     * @param value      运费
     */
    private void setShippingFeeCache(String storeId, List<TempOrderItemVo> orderItems, BigDecimal value) {
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(storeId).append("_").append(
                Joiner.on("_").join(orderItems.stream().map(tempOrderItemVo -> String.format("%s_%s", tempOrderItemVo.getProductCode(), tempOrderItemVo.getCount())).collect(Collectors.toList()))
        );
        shippingFeeOps.set(cacheKey.toString(), value, 10, TimeUnit.MINUTES);
    }

    /**
     * 获取缓存价格
     *
     * @param storeKey 店铺标记
     * @param sku      商品代码
     * @return
     */
    private FashionPriceVo getProductPriceInCache(String storeKey, String sku) {
        FashionPriceVo fashionPriceVo = productPriceOps.get(String.format("cache.orderservice.product.price.%s_%s", storeKey, sku));
        logs.info("使用缓存价格-> storeKey: {}, sku: {}, price: {}", storeKey, sku, fashionPriceVo);
        return fashionPriceVo;
    }

    /**
     * 更新缓存价格
     *
     * @param storeKey 店铺标记
     * @param sku      商品代码
     * @param value    价格对象
     */
    private void setProductPriceInCache(String storeKey, String sku, FashionPriceVo value) {
        productPriceOps.set(String.format("cache.orderservice.product.price.%s_%s", storeKey, sku), value, 10, TimeUnit.MINUTES);
    }

    /**
     * 查询订单状态
     *
     * @param orderNo 订单编号
     * @return orderNo
     */
    public String findStatusByOrderNo(String orderNo) {
        return orderRepos.findStatusByOrderNo(orderNo);
    }

    /**
     * 获取订单号
     *
     * @param id id
     * @return orderNo
     */
    public String findOrderNoById(String id) {
        return orderRepos.findOrderNoById(id);
    }

    /**
     * 查询主键
     *
     * @param orderNo 订单编号
     * @return String
     */
    public String findIdByOrderNo(String orderNo) {
        return orderRepos.findIdByOrderNo(orderNo);
    }

    /**
     * 查询店铺类型
     *
     * @param orderNo 订单编号
     * @return String
     */
    public String findStoreTypeByOrderNo(String orderNo) {
        return orderRepos.findStoreTypeByOrderNO(orderNo);
    }

    /**
     * 查询订单地址ID
     *
     * @param orderNo 订单编号
     * @return String
     */
    public String findAddressIdByOrderNo(String orderNo) {
        return orderRepos.findAddressIdByOrderNo(orderNo);
    }

    /**
     * 取消订单
     * @param key
     * @param cancelOrderType
     */
    public int cancelOrder(OrderKey key, Contants.CancelOrderType cancelOrderType) {
        /**LWX 2017/1/9修改： 增加取消订单类型判断，区分系统出错取消跟客户自主取消 START */
        String newOrderStatus = OrderMain.order_status_cancel;
        switch (cancelOrderType) {
            case ERROR:
                newOrderStatus = OrderMain.order_status_error;
                break;
            case OVERTIMED:
                newOrderStatus = OrderMain.order_status_outoftime_cancel;
                break;
            case USER:
            default:
                newOrderStatus = OrderMain.order_status_cancel;
        }
        /**LWX 2017/1/9修改： 增加取消订单类型判断，区分系统出错取消跟客户自主取消 END */
        if(Lang.isEmpty(key.getOrderId())) {
            return orderRepos.updateStatusByOrderNo(key.getOrderNo(), newOrderStatus);
        } else {
            return orderRepos.updateStatusById(key.getOrderId(), newOrderStatus);
        }
    }


    @Autowired
    MemberApiStub memberApi;
    @Autowired
    SalesPriceRateQueryApiStub salesPriceRateQueryApi;
    @Autowired
    GroupBuyingApiStub groupBuyingApi;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    OrderItemRepos orderItemRepos;
    @Autowired
    SubOrderRepos subOrderRepos;
    @Autowired
    OrderItemRelationsRepos orderItemRelationsRepos;
    @Autowired
    SubOrderItemRepos subOrderItemRepos;
    @Autowired
    OrderGiftRepos orderGiftRepos;
    @Autowired
    OrderRepos orderRepos;
    @Autowired
    SequenceGenerator sequenceGenerator;

    @MotanReferer
    ProductFashionApi productFashionApi;

    @MotanReferer
    GoodsApi goodsApi;

    @MotanReferer
    OutsideProductApi outsideProductApi;
    @MotanReferer
    MemberAddressApi memberAddressApi;
    @MotanReferer
    AddressCommonApi addressCommonApi;
    @MotanReferer
    MemberInvoinceApi memberInvoinceApi;
    @MotanReferer
    CoreCompDepartUserApi coreCompDepartUserApi;
    @MotanReferer
    CoreCompanyApi coreCompanyApi;
    @MotanReferer
    SystemConfigApi systemConfigApi;
    @MotanReferer
    ShareApi shareApi;
    @MotanReferer
    SystemLogApi systemLogApi;
    @MotanReferer
    ActivityConfigurationApi activityConfigurationApi;
    @MotanReferer
    ActivityGoodsApi activityGoodsApi;
    @MotanReferer
    MemberCreditsHitsApi memberCreditsHitsApi;
    @Autowired
    EntityManager entityManager;
    @MotanReferer
    StoreApi storeApi;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @MotanReferer
    JdekApi jdekApi;
    @MotanReferer
    PriceParityApi priceParityApi;
    @MotanReferer
    ProductApi productApi;
    @Autowired
    OrderParityRepos orderParityRepos;
    @MotanReferer
    MemberCreditsTranApi tranApi;
    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    DepositHistoryApi depositHistoryApi;
    @MotanReferer
    OrganizationCreditsApi organizationCreditsApi;
    @MotanReferer
    SalesPriceRateApi salesPriceRateApi;

    @Autowired
    OrderMainQueryService orderMainQueryService;


    @Transactional(readOnly = false)
    public OrderMain saveOrder(OrderMain orderMain, Boolean flush) {
        if(flush) {
            return orderRepos.saveAndFlush(orderMain);
        } else {
            return orderRepos.save(orderMain);
        }
    }

    /**
     * 批量更新订单状态
     * @param orderNo 订单号（列表）
     * @param status 订单状态
     */
    public void updateBatchStatusByOrderNo(List<String> orderNo, GlobalContants.ORDER_STATUS status) {
        if(orderNo != null && !orderNo.isEmpty()) {
            orderRepos.updateBatchStatusByOrderNo(status.getValue() , orderNo);
        }
    }

    /**
     * 根据第三方订单信息，更新orderMain
     * @param orderKey 集采订单
     * @param trdOrder 第三方订单
     */
    @Transactional(readOnly = false, rollbackFor = Exception.class)
    public void updateTrdOrderInfo(OrderKey orderKey, TrdOrder trdOrder) {
        OrderMain orderMain = orderMainQueryService.findByKey(orderKey);
        //1. 处理订单状态
        orderMain.setStatus(trdOrder.getFinalStatus().getValue());

        //2. 处理拆单
        List<SubOrder> subOrderList = orderMain.getSubOrders();
        List<String> subOrderTrdNos = subOrderList.stream().map(SubOrder::getSubOrderNo).collect(Collectors.toList());
        List<String> trdSubOrderNos = trdOrder.getCorders() == null ? new ArrayList<>() : trdOrder.getCorders().stream().map(TrdOrder::getTrdOrderNo).collect(Collectors.toList());

        List<String> deletedTrdNos = subOrderTrdNos;
        deletedTrdNos.removeAll(trdSubOrderNos);
        List<String> addedTrdNos = trdSubOrderNos;
        addedTrdNos.removeAll(subOrderTrdNos);
        // 删除第三方供应商已删除的订单
        if(deletedTrdNos.size() > 0) {
            subOrderRepos.delete(subOrderList.stream().filter(it -> deletedTrdNos.contains(it.getSubOrderNo())).collect(Collectors.toList()));
            subOrderList.removeIf(it -> deletedTrdNos.contains(it.getSubOrderNo()));
        }
        // 处理子单信息变更
        for(SubOrder so : subOrderList) {
            final String subOrderNo = so.getSubOrderNo();
            Optional<TrdOrder> tOrder = trdOrder.getCorders().stream().filter(it -> it.getTrdOrderNo().equals(subOrderNo)).findFirst();
            if(tOrder.isPresent()) {
                List<String> supplierOrderSkus = tOrder.get().getSku().stream().map(TrdOrderSku::getSkuId).collect(Collectors.toList());
                SubOrder newSubOrder = OrderHelper.toSubOrder(tOrder.get(), orderMain);
                newSubOrder.setId(so.getId());
                newSubOrder.setVersion(so.getVersion());
                newSubOrder.setDateCreated(so.getDateCreated());
                newSubOrder.setIsDelete(false);
                so = newSubOrder;
                so.setOrder(orderMain);
            }
        }
        // 第三方供应商新增子单
        if(addedTrdNos.size() > 0) {
            for(String trdNo : addedTrdNos) {
                trdOrder.getCorders().stream().filter(it -> it.getTrdOrderNo().equals(trdNo)).findFirst().ifPresent(it -> {
                    subOrderList.add(OrderHelper.toSubOrder(it, orderMain));
                });
            }
        }
        orderMain.setThirdOrderNo(trdOrder.getTrdOrderNo());
        orderMain.setSubOrders(subOrderList);
        orderRepos.saveAndFlush(orderMain);
    }


    /**
     * 讲OrderMain转换为OrderVo
     * @param orderMain
     * @param payment
     * @param memberAddress
     * @return
     */
    public OrderVo toOrderVo(OrderMain orderMain, Payment payment, MemberAddressDto memberAddress) {
        OrderVo orderVo = BeanMapper.map(orderMain, BeanMapper.getType(OrderMain.class), BeanMapper.getType(OrderVo.class));
        orderVo.setOrderItems(BeanMapper.mapList(orderMain.getOrderItems(), BeanMapper.getType(OrderItem.class), BeanMapper.getType(OrderItemVo.class)));
        orderVo.setPayment(BeanMapper.map(payment, BeanMapper.getType(Payment.class), BeanMapper.getType(OrderPaymentVo.class)));
        orderVo.setOrderReceiver(BeanMapper.map(memberAddress, BeanMapper.getType(MemberAddressDto.class), BeanMapper.getType(OrderReceiver.class)));
        orderVo.setOrderId(orderMain.getId());
        orderVo.setOrderNo(orderMain.getOrderNo());
        return orderVo;
    }

}
