package order.service.service;

import order.model.po.OrderTemplateAdapterConfig;
import order.model.repository.OrderTemplateAdapterConfigRepos;
import order.service.specification.OrderTemplateConfigQuerySpecification;
import order.vo.query.OrderTemplateAdapterConfigQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 订单操作模板配置表Service
 *
 * @author Liang Wenxu
 * @since 2018/7/9
 */
@Service
@Transactional(readOnly = true, rollbackFor = Exception.class)
public class OrderTemplateAdapterConfigService {
    @Autowired
    OrderTemplateAdapterConfigRepos repos;

    /**
     * 简单条件查询
     *
     * @param query    查询参数，各属性之间是and关系
     * @param pageable 分页
     * @return
     */
    public Page<OrderTemplateAdapterConfig> query(OrderTemplateAdapterConfigQuery query, Pageable pageable) {
        return repos.findAll(new OrderTemplateConfigQuerySpecification(query), pageable);
    }

    /**
     * 简单条件查询
     *
     * @param query 查询参数，各属性之间是and关系
     * @return
     */
    public List<OrderTemplateAdapterConfig> query(OrderTemplateAdapterConfigQuery query) {
        return repos.findAll(new OrderTemplateConfigQuerySpecification(query, false));
    }

//    /**
//     * 启用指定的订单处理模型
//     * @param storeCode 店铺代码
//     * @param templateName 处理模板名称
//     * @return
//     */
//    public Boolean enable(String storeCode, String templateName) {
//        return changeEnabled(storeCode, templateName, true);
//    }
//
//    /**
//     * 禁用指定的订单处理模型
//     * @param storeCode 店铺代码
//     * @param templateName 处理模板名称
//     * @return
//     */
//    public Boolean disable(String storeCode, String templateName) {
//        return changeEnabled(storeCode, templateName, false);
//    }
//
//    /**
//     * 改变enable的值
//     * @param storeCode 店铺代码
//     * @param templateName 处理模板名称
//     * @param enabled true | false 启用 | 禁用
//     * @return
//     */
//    public Boolean changeEnabled(String storeCode, String templateName, Boolean enabled) {
//        OrderTemplateAdapterConfigQuery query = new OrderTemplateAdapterConfigQuery();
//        query.setStoreCode(storeCode);
//        query.setTemplateName(templateName);
//        // 确保只有一个被启用
//        List<OrderTemplateAdapterConfig> configs = this.query(query);
//        if(configs != null && configs.size() > 0) {
//            // 先查找符合条件的未删除的记录
//            List<OrderTemplateAdapterConfig> unDelList = configs.stream()
//                    .filter(c -> !c.getIsDelete()).collect(Collectors.toList());
//            if(unDelList != null) {
//                // 只有一条，修改其状态即可
//                if(unDelList.size() == 1) {
//                    unDelList.get(0).setEnabled(enabled);
//                } else {
//                    // 有多条的话，这是有问题的数据，不作处理了！
//                    return true;
//                }
//            }
//            // 查找符合条件的已删除的记录
//            List<OrderTemplateAdapterConfig> delList = configs.stream().filter(c -> c.getIsDelete()).collect(Collectors.toList());
//            if(delList != null && delList.size() > 0) {
//                if(enabled) {
//                    // 如果是数据已删除，又修改成可用，将删除标志回写
//                    unDelList.get(0).setEnabled(enabled);
//                    unDelList.get(0).setIsDelete(false);
//                }
//            }
//
//            repos.save(unDelList);
//            return true;
//        }
//
//        return false;
//    }
}
