package order.service.service;

import payment.model.po.PaymentConfig;
import payment.model.repository.PaymentConfigRepos;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2018/8/9
 */
@Slf4j
@Service
public class PaymentConfigService {
    public PaymentConfig findByCode(String code) {
        return paymentConfigRepos.findByCode(code);
    }

    public PaymentConfig findById(String id) {
        return paymentConfigRepos.findById(id);
    }

    public List<PaymentConfig> findByIdIn(List<String> ids) {
        return paymentConfigRepos.findByIdIn(ids);
    }

    public List<PaymentConfig> findByIsDeleteOrderByCodeAsc(Boolean isDelete) {
        return paymentConfigRepos.findByIsDeleteOrderByCodeAsc(isDelete);
    }

    public List<PaymentConfig> findByCodeIn(List<String> codes) {
        return paymentConfigRepos.findByCodeIn(codes);
    }

    @Autowired
    PaymentConfigRepos paymentConfigRepos;
}
