package order.service.service.impl;

import lombok.extern.slf4j.Slf4j;
import order.dto.MallAttachmentDto;
import order.model.po.MallAttachment;
import order.model.repository.MallAttachmentRepo;
import order.service.service.MallAttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.data.BeanMapper;

import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/14
 */
@Slf4j
@Service
public class MallAttachmentServiceImpl implements MallAttachmentService {

    @Autowired
    private MallAttachmentRepo mallAttachmentRepo;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse<List<MallAttachmentDto>> batchSave(List<MallAttachmentDto> mallAttachmentDtoList) {
        List<MallAttachment> mallAttachments = BeanMapper.mapList(mallAttachmentDtoList,MallAttachmentDto.class,MallAttachment.class);
        MallAttachmentDto attachmentDto = mallAttachmentDtoList.get(0);
        if (Lang.isEmpty(attachmentDto.getAttachmentCorrelation())||Lang.isEmpty(attachmentDto.getBusinessCode())){
            return new BaseResponse<>("参数有误，缺少业务附件关联或业务代码");
        }
        List<MallAttachment> attachments = mallAttachmentRepo.findByAttachmentCorrelationAndBusinessCode(attachmentDto.getAttachmentCorrelation(), attachmentDto.getBusinessCode());
        if (!Lang.isEmpty(attachments)){
            mallAttachmentRepo.delete(attachments);
        }
        List<MallAttachment> listSaved = mallAttachmentRepo.save(mallAttachments);
        return new BaseResponse<>(true,"",BeanMapper.mapList(listSaved,MallAttachment.class,MallAttachmentDto.class));
    }

    @Override
    public List<MallAttachmentDto> findMallAttachments(String memberId) {
        //mallAttachmentRepo.findByAttachmentCorrelationAndIsDelete()
        return null;
    }
}
