package order.service.service.impl;

import lombok.extern.slf4j.Slf4j;
import order.dto.MallAttachmentDto;
import order.dto.MallParentOrderDto;
import order.dto.MallTempOrderDto;
import order.model.po.MallAttachment;
import order.model.po.MallTempGoods;
import order.model.po.MallTempOrder;
import order.model.repository.MallParentOrderRepo;
import order.model.repository.MallTempOrderRepo;
import order.service.service.MallTempOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.data.BeanMapper;

import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 */
@Slf4j
@Service
public class MallTempOrderServiceImpl implements MallTempOrderService {

    @Autowired
    private MallTempOrderRepo mallTempOrderRepo;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse saveMallTempOrder(MallTempOrderDto mallTempOrderDto) {
        if (!Lang.isEmpty(mallTempOrderDto.getId())){
            MallTempOrder mallTempOrderOld = mallTempOrderRepo.findOne(mallTempOrderDto.getId());
            if (!Lang.isEmpty(mallTempOrderOld)) {
                mallTempOrderRepo.delete(mallTempOrderOld);
            }
        }
        MallTempOrder mallTempOrder = BeanMapper.map(mallTempOrderDto, MallTempOrder.class);
        mallTempOrder.getMallTempGoods().forEach(tempGoods->{
           tempGoods.setMallTempOrder(mallTempOrder);
        });
        mallTempOrderRepo.save(mallTempOrder);
        return new BaseResponse(true,"保存成功");
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse deleteMallTempOrder(List<String> ids) {
        if(ids.size()==1000){
            // 0-499  500-999
            List<String> subList = ids.subList(0, ids.size() / 2 - 1);
            List<String> subList2 = ids.subList(subList.size(), ids.size());
            mallTempOrderRepo.deleteByIdIn(subList);
            mallTempOrderRepo.deleteByIdIn(subList2);
        }else{
            mallTempOrderRepo.deleteByIdIn(ids);
        }
        return new BaseResponse(true,"删除临时订单成功");
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse deleteMallTempOrder(String memberId) {
        mallTempOrderRepo.deleteAllByMemberId(memberId);
        return new BaseResponse(true,"删除临时订单成功");
    }

    @Override
    public BaseResponse updateTempOrder(String addressId, String memberId, String errorInfo) {
        mallTempOrderRepo.updateTempOrder(errorInfo,addressId,memberId);
        return null;
    }

}
