package order.service.service.impl;

import cart.api.OrderMainApi;
import cart.api.OrderMainAttrApi;
import cart.api.SubOrderApi;
import cart.api.TrdSpOrderStatusApi;
import cart.api.difinication.Business;
import cart.api.difinication.Organization;
import cart.api.difinication.TrdSpOrderOperation;
import cart.api.difinication.TrdSpOrderStatus;
import cart.api.dto.mallStatus.MallStatusMachineDto;
import cart.api.dto.order.SubOrderDto;
import cart.api.dto.order.SubOrderItemDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import order.model.po.OrderItem;
import order.model.po.OrderMain;
import order.model.po.SubOrder;
import order.model.po.SubOrderItem;
import order.model.repository.OrderRepos;
import order.model.repository.SubOrderRepos;
import order.service.service.StoreOrderService;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import utils.Lang;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Service
public class StoreOrderServiceImpl implements StoreOrderService {
    @Autowired
    RedisTemplate redisTemplate;
    @MotanReferer
    TrdSpOrderStatusApi trdSpOrderStatusApi;

    @Autowired
    OrderRepos orderRepos;

    @Autowired
    SubOrderRepos subOrderRepos;

    @MotanReferer
    OrderMainApi orderMainApi;

    final static Logger logger = org.slf4j.LoggerFactory.getLogger(StoreOrderService.class);

    @Override
    public void cancleOrder(String thirdOrderNo, String StoreId, String orderId) {
        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps("LocalCancelOrder:thirdOrderNo" + thirdOrderNo+'4');
        if (boundValueOperations.setIfAbsent(true)) {
            boundValueOperations.expire(1,TimeUnit.MILLISECONDS);
            MallStatusMachineDto mallStatusMachineDto = trdSpOrderStatusApi.findNextTrdOrderStatus(Business.Order, Organization.TrdSp, TrdSpOrderOperation.Cancel, TrdSpOrderStatus.Obligation);
            if (Lang.isEmpty(mallStatusMachineDto.getNextStatusCode())) {
                logger.info("statusCode:{}", JSON.toJSONString(mallStatusMachineDto.getNextStatusCode()));
            } else {
                int i = orderRepos.updateTrdSpStatus(mallStatusMachineDto.getNextStatusCode(), thirdOrderNo, StoreId);
                if(i<=0){
                    logger.info("取消订单失败");
                }
            }
            int i=subOrderRepos.updateSubOrderState(orderId,mallStatusMachineDto.getNextStatusCode());
            if(i<=0){
                logger.info("取消订单时候,更新SubOrder状态失败");
            }
        }

    }

    @Override
    public void confimOrder(String thirdOrderNo, String StoreId, String orderId) {
        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps("LocalConfirmOrder:thirdOrderNo" + thirdOrderNo);
        if (boundValueOperations.setIfAbsent(true)) {
            boundValueOperations.expire(1,TimeUnit.MILLISECONDS);
            MallStatusMachineDto mallStatusMachineDto = trdSpOrderStatusApi.findNextTrdOrderStatus(Business.Order, Organization.TrdSp, TrdSpOrderOperation.Firm, TrdSpOrderStatus.Obligation);
            if (Lang.isEmpty(mallStatusMachineDto.getNextStatusCode())) {
                logger.info("statusCode:{}", JSON.toJSONString(mallStatusMachineDto.getNextStatusCode()));
            } else {
                int i = orderRepos.updateTrdSpStatus(mallStatusMachineDto.getNextStatusCode(), thirdOrderNo, StoreId);
                if(i<=0){
                    logger.info("确认订单失败");
                }
            }
            int i=subOrderRepos.updateSubOrderState(orderId,mallStatusMachineDto.getNextStatusCode());
            if(i<=0){
                logger.info("确认预占库存时候,更新SubOrder状态失败");
            }
        }

    }

    @Override
    public void takeOrder(String orderNo,String StoreId){
        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps("LocalTakeOrder:thirdOrderNo" + orderNo);
        if (boundValueOperations.setIfAbsent(true)) {
            boundValueOperations.expire(1,TimeUnit.MILLISECONDS);
            MallStatusMachineDto mallStatusMachineDto = trdSpOrderStatusApi.findNextTrdOrderStatus(Business.Order, Organization.TrdSp, TrdSpOrderOperation.TrdSpNewOperation, TrdSpOrderStatus.TrdSpNew);
            if (Lang.isEmpty(mallStatusMachineDto.getNextStatusCode())) {
                logger.info("statusCode:{}", JSON.toJSONString(mallStatusMachineDto.getNextStatusCode()));
            } else {
                int i = orderRepos.updateTrdSpStatusByOrderNo(mallStatusMachineDto.getNextStatusCode(), orderNo, StoreId);
                if(i<=0){
                    logger.info("订单号"+orderNo+"预占库存失败");
                }
            }

        }
    }

    @Override
    public void addSubOrder(String orderNo){
        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps("addSubOrder:subOrderNo" + orderNo);
        if (boundValueOperations.setIfAbsent(true)) {
            boundValueOperations.expire(1,TimeUnit.MILLISECONDS);
            OrderMain orderMain=orderRepos.findByOrderNo(orderNo);
            SubOrder subOrder=new SubOrder();
            List<SubOrderItem> list=new ArrayList<>();

            subOrder.setSubOrderNo(orderMain.getThirdOrderNo());
            subOrder.setTrdOrderState(orderMain.getTrdSpStatus());
            subOrder.setFreight(orderMain.getFreight());
            subOrder.setJdstatus(orderMain.getJdstatus());
            subOrder.setSumCostPrice(orderMain.getSumPrice());
            subOrder.setOrder(orderMain);
            for (OrderItem o:orderMain.getOrderItems()){
                SubOrderItem subOrderItem=new SubOrderItem();
                subOrderItem.setCount(o.getCount());
                subOrderItem.setName(o.getProductName());
                subOrderItem.setPrice(o.getCostPrice());
                subOrderItem.setSkuId(o.getSku());

                subOrderItem.setSubOrder(subOrder);
                subOrderItem.setOrder(orderMain);
                subOrderItem.setOrderItem(o);

                if(o.getProductType()!=null){
                    subOrderItem.setType(Integer.valueOf(o.getProductType()));
                }
                list.add(subOrderItem);
            }
            subOrder.setSubOrderItems(list);
            subOrderRepos.save(subOrder);
        }
    }
}
