package order.service.service.impl.query;

import lombok.extern.slf4j.Slf4j;
import order.dto.MallTempOrderDto;
import order.model.po.MallTempOrder;
import order.model.repository.MallTempOrderRepo;
import order.service.service.query.MallTempOrderQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.data.BeanMapper;

import java.util.ArrayList;
import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 */
@Slf4j
@Service
public class MallTempOrderQueryServiceImpl implements MallTempOrderQueryService {

    @Autowired
    private MallTempOrderRepo mallTempOrderRepo;

    @Override
    @Transactional
    public List<MallTempOrderDto> findAllMallTempOrder(String memeberId) {
        List<MallTempOrder> mallTempOrders = mallTempOrderRepo.findByMemberId(memeberId);
        if(!Lang.isEmpty(mallTempOrders)){
            List<MallTempOrderDto> mallTempOrderDtos = BeanMapper.mapList(mallTempOrders, MallTempOrder.class, MallTempOrderDto.class);
            return mallTempOrderDtos;
        }
        return new ArrayList<>();
    }

    @Override
    @Transactional
    public MallTempOrderDto findMallTempOrderById(String orderId) {
        MallTempOrder mallTempOrder = mallTempOrderRepo.findById(orderId);
        MallTempOrderDto mallTempOrderDto = BeanMapper.map(mallTempOrder,MallTempOrderDto.class);
        return mallTempOrderDto;
    }

    @Override
    public Integer countMallTempOrder(String memberId) {
        List<MallTempOrder> mallTempOrderList = mallTempOrderRepo.findByMemberId(memberId);
        Integer size=0;
        if(!Lang.isEmpty(mallTempOrderList)){
             size = mallTempOrderList.size();
        }
        return size;
    }

}
