package order.service.service.query;

import order.dto.MallParentOrderDto;
import order.dto.MallParentSubOrderNosDto;
import order.dto.SimpleParentOrderDto;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 */
public interface MallParentOrderQueryService {
    BaseResponse<List<MallParentOrderDto>> findAllMallParentOrder();

    /**
     * 获取商城子订单号列表
     *
     * @param parentOrderNo
     * @return
     */
    MallParentSubOrderNosDto getMallSubOrderNos(String parentOrderNo);

    /**
     * 获取商城父订单
     *
     * @param parentOrderNo
     * @return
     */
    BaseResponse<SimpleParentOrderDto> getSimpleParentOrderDto(String parentOrderNo);

    /**
     * 根据订单号查询父订单
     *
     * @param parentOrderNo
     * @return
     */
    MallParentOrderDto findByOrderNo(String parentOrderNo);

    /**
     * 根据父订单id获取父订单
     *
     * @param parentOrderId
     * @return
     */
    MallParentOrderDto findParentOrderById(String parentOrderId);

    /**
     * 获取商城父订单号
     *
     * @param id
     * @return
     */
    BaseResponse<String> findParentOrderNo(String id) ;


}
