package order.service.service.query;

import cart.api.difinication.TrdSpOrderStatus;
import cart.api.dto.order.CartSimpleMallOrderDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsApi;
import goods.dto.goods.GoodsPictureDto;
import member.api.dto.shop.MemberAddressDto;
import order.dto.OrderQueryDto;
import order.model.po.*;
import order.model.repository.OrderRepos;
import order.model.repository.SubOrderRepos;
import order.model.specification.OrderMainSpecification;
import order.service.specification.QueryProviderOrdersSpecification;
import order.service.stubs.MemberAddressApiStub;
import order.service.stubs.ShippingInfoApiStub;
import order.vo.OrderItemVo;
import order.vo.OrderKey;
import order.vo.query.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pool.commonUtil.MessageDictionary;
import shipping.api.dto.SubOrderShippingListDto;
import sinomall.global.common.response.BaseResponse;
import store.api.MallShippingApi;
import store.api.dto.mapdto.MallShippingDto;
import utils.Lang;
import utils.collection.CollectionUtil;
import utils.sql.PageVo;

import javax.persistence.criteria.Predicate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2018/8/13
 */
@Service
@Transactional(readOnly = true)
public class OrderMainQueryService {
    @Autowired
    OrderRepos orderRepos;
    @Autowired
    SubOrderRepos subOrderRepos;

    @Autowired
    MemberAddressApiStub memberAddressApi;

    @Autowired
    ShippingInfoApiStub shippingInfoApi;

    @MotanReferer
    GoodsApi goodsapi;
    @MotanReferer
    MallShippingApi mallShippingApi;


    /**
     * 根据OrderNo查询订单详细内容
     *
     * @param
     */
    @Transactional
    public BaseResponse queryProviderOrdersDetails(String orderNo) {

        if (Lang.isEmpty(orderNo))
            return new BaseResponse(false, MessageDictionary.RETURN_INTERNAL_ERROR_MESSAGE, "", MessageDictionary.RETURN_INTERNAL_EXCEPTION_CODE);
        OrderDetailQueryVo orderDetailQueryVo = new OrderDetailQueryVo();
        OrderMain byOrderNo = orderRepos.findByOrderNo(orderNo);
        if (!Lang.isEmpty(byOrderNo)) {
            orderDetailQueryVo.setOrderId(byOrderNo.getId());//设置订单ID
            orderDetailQueryVo.setOrderNo(byOrderNo.getOrderNo());//订单号
            orderDetailQueryVo.setStoreName(byOrderNo.getStoreName());//供应商
            orderDetailQueryVo.setAddressName(byOrderNo.getAddressName());//订单Address
            orderDetailQueryVo.setCreatedTime(byOrderNo.getCreateTime());// 订单创建时间
            orderDetailQueryVo.setSumCostPrice(byOrderNo.getSumPrice());//订单总金额
            MemberAddressDto byId = memberAddressApi.findById(byOrderNo.getAddressId());//地址ID ,可以根据地址ID 来查询 Member_ADDRESS 查询数据
            if (byId != null) {
                orderDetailQueryVo.setMemberName(byId.getUsername());
                orderDetailQueryVo.setMemberTel(byId.getPhone());
                //订单Address
                // String address=byId.getCountryName()+byId.getProvinceName()+byId.getCityName()+byId.getTownName()+byId.getDetailaddress();
            }
            List<OrderItemVo> list = new ArrayList<>();
            List<OrderItem> orderItems = byOrderNo.getOrderItems();//订单子项
            if (!Lang.isEmpty(orderItems)) {
                //订单详细信息

                orderItems.stream().forEach(orderItem -> {
                    OrderItemVo orderItemVo = new OrderItemVo();
                    orderItemVo.setProductName(orderItem.getProductName());//商品名字
                    orderItemVo.setProductPic(orderItem.getProductPic());
                    orderItemVo.setCount(orderItem.getCount());
                    orderItemVo.setFinalPrice(orderItem.getFinalPrice());//最终价格(商品)
                    orderItemVo.setGoodsId(orderItem.getGoodsId());//商品编号
                    orderItemVo.setProductPrice(orderItem.getProductPrice());//商品单价
                    list.add(orderItemVo);
                });
            }
            orderDetailQueryVo.setChildren(list);
            BigDecimal totalPrice = new BigDecimal(0);//初始值
            //针对于 供应商发货的情况之下
            List<SubOrder> subOrders = byOrderNo.getSubOrders();//子订单
            List<SubOrderItemWithSubOrderNo> subOrderItemWithSubOrderNos = new ArrayList<>();
            if (!Lang.isEmpty(subOrders)) {
                for (SubOrder subOrder : subOrders) {
                    List<SubOrderItemQueryVo> subOrderItemQueryVos = new ArrayList<>();
                    BigDecimal SubOrderSumPrice = new BigDecimal(0);//初始值，子订单总价
                    SubOrderItemWithSubOrderNo subOrderItemWithSubOrderNo = new SubOrderItemWithSubOrderNo();
                    BigDecimal subOrderStatusAfterSendOrder = new BigDecimal(0);//初始值，子订单状态 (数量)

                    if (TrdSpOrderStatus.Sent.getCode().equals(subOrder.getTrdOrderState()) ||
                        TrdSpOrderStatus.Received.getCode().equals(subOrder.getTrdOrderState()) ||
                        TrdSpOrderStatus.Rejected.getCode().equals(subOrder.getTrdOrderState())
                       ) {
                    /*if ("1".equals(subOrder.getTrdOrderState()) ||
                            "2".equals(subOrder.getTrdOrderState()) ||
                            "4".equals(subOrder.getTrdOrderState())
                    ) {*/
                        subOrderStatusAfterSendOrder = subOrderStatusAfterSendOrder.add(new BigDecimal(1));
                    }
                    for (SubOrderItem subOrderItem : subOrder.getSubOrderItems()) {
                        SubOrderItemQueryVo subOrderItemQueryVo = new SubOrderItemQueryVo();
                        subOrderItemQueryVo.setCount(subOrderItem.getCount());
                        subOrderItemQueryVo.setId(subOrderItem.getId());
                        subOrderItemQueryVo.setNakedPrice(subOrderItem.getNakedPrice());
                        subOrderItemQueryVo.setTaxPrice(subOrderItem.getTaxPrice());
                        subOrderItemQueryVo.setCount(subOrderItem.getOrderItem().getCount());//商品数量
                        subOrderItemQueryVo.setSkuId(subOrderItem.getOrderItem().getSku());//商品sku
                        subOrderItemQueryVo.setPrice(subOrderItem.getOrderItem().getFinalPrice());//商品最终价格
                        subOrderItemQueryVo.setName(subOrderItem.getOrderItem().getProductName());//商品编号
                        subOrderItemQueryVo.setGoodsId(subOrderItem.getOrderItem().getGoodsId());//商品编号
                        //重新设置商品图片

                        //subOrderItemQueryVo.setPicturePath(subOrderItem.getOrderItem().getProductPic());//商品图片
                        List<GoodsPictureDto> picturesBySku = goodsapi.getPicturesBySku(subOrderItem.getSkuId());

                            if (!Lang.isEmpty(picturesBySku)&&!Lang.isEmpty(picturesBySku.get(0))){
                                subOrderItemQueryVo.setPicturePath(picturesBySku.get(0).getPicturePath());
                            }

                        totalPrice = totalPrice.add(subOrderItem.getOrderItem().getFinalPrice().multiply(new BigDecimal(subOrderItem.getOrderItem().getCount())));
                        SubOrderSumPrice = SubOrderSumPrice.add(subOrderItem.getOrderItem().getFinalPrice().multiply(new BigDecimal(subOrderItem.getOrderItem().getCount())));
                        subOrderItemQueryVos.add(subOrderItemQueryVo);
                    }

                    orderDetailQueryVo.setTotalPrice(totalPrice);//总价
                    orderDetailQueryVo.setSingleSubOrderStatus(subOrder.getTrdOrderState()); //设置未拆单(分包裹)的订单的订单的状态
                   // List<SubOrderShippingListDto> shippingListByTraceNo = shippingInfoApi.findShippingListBySuborderId(subOrder.getId());
                    List<SubOrderShippingListVo> subOrderShippingListVos = new ArrayList<>();


                    List<MallShippingDto> mallShipping = mallShippingApi.findMallShipping(subOrder.getOrder().getOrderNo());
                    final String[] shippingNo = {""};
                    //这里还要判断这里的状态是否是在已发货之后的订单状态,否者会添加

                    //if(){  //subOrders.getTrdOrderState();
                    if(!Lang.isEmpty(mallShipping)){
                        mallShipping.forEach(mallShippingDto -> {
                            SubOrderShippingListVo subOrderShippingListVo = new SubOrderShippingListVo();
                            subOrderShippingListVo.setLogisticNo(mallShippingDto.getShippingNo());
                            subOrderShippingListVo.setShippingCompanyName(mallShippingDto.getShippingCompany());
                            subOrderShippingListVo.setShippingRemark(mallShippingDto.getRemark());
                            subOrderShippingListVo.setShippingType(mallShippingDto.getShippingType());
                            subOrderShippingListVo.setShippingStatus(subOrder.getTrdOrderState());//设置物流状态,就是子订单状态
                            subOrderShippingListVos.add(subOrderShippingListVo);

                        });
                    }  // }

                    /*shippingListByTraceNo.stream().forEach(subOrderShippingListDto -> {
                        SubOrderShippingListVo subOrderShippingListVo = new SubOrderShippingListVo();
                        subOrderShippingListVo.setLogisticNo(subOrderShippingListDto.getLogisticNo());
                        subOrderShippingListVo.setShippingCompanyName(subOrderShippingListDto.getShippingCompanyName());
                        subOrderShippingListVo.setShippingRemark(subOrderShippingListDto.getShippingRemark());
                        subOrderShippingListVo.setShippingType(subOrderShippingListDto.getShippingType());
                        subOrderShippingListVo.setShippingStatus(subOrder.getTrdOrderState());//设置物流状态,就是订单状态
                        subOrderShippingListVos.add(subOrderShippingListVo);
                    });*/

                    subOrderItemWithSubOrderNo.setSubOrderShippingListVos(subOrderShippingListVos);
                    subOrderItemWithSubOrderNo.setSubOrderStatusAfterSendOrder(subOrderStatusAfterSendOrder);
                    subOrderItemWithSubOrderNo.setSubOrderStatus(subOrder.getTrdOrderState());//设置状态
                    subOrderItemWithSubOrderNo.setSubOrderNo(subOrder.getSubOrderNo());//设置子订单号
                    subOrderItemWithSubOrderNo.setSubOrderItemQueryVos(subOrderItemQueryVos);//订单项
                    subOrderItemWithSubOrderNo.setSubOrderSumPrice(SubOrderSumPrice);//子订单总价
                    subOrderItemWithSubOrderNos.add(subOrderItemWithSubOrderNo);
                    orderDetailQueryVo.setSubOrderItemWithSubOrderNo(subOrderItemWithSubOrderNos);
                }
            }
        }
        return new BaseResponse(true, MessageDictionary.RETURN_SUCCESS_MESSAGE, orderDetailQueryVo, MessageDictionary.RETURN_SUCCESS_CODE);
    }


    /**
     * 分页查询数据
     *
     * @param
     */
    @Transactional
    public BaseResponse queryProviderOrdersPage(OrderQueryDto orderQueryDto) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            if (!Lang.isEmpty(orderQueryDto) && Lang.isEmpty(orderQueryDto.getPageNo())) {
                orderQueryDto.setPageNo(0);
            }
            if (!Lang.isEmpty(orderQueryDto) && Lang.isEmpty(orderQueryDto.getPageSize())) {
                orderQueryDto.setPageSize(10);
            }
            if (Lang.isEmpty(orderQueryDto)) {
                orderQueryDto = new OrderQueryDto();
                orderQueryDto.setPageNo(0);
                orderQueryDto.setPageSize(10);
            }
            int pageNo = orderQueryDto.getPageNo();
            int pageSize = orderQueryDto.getPageSize();
            //查询时页码数 -1
            //int realPageNo = pageNo;//- 1 > 0 ? pageNo - 1 : 0;

            //3、列表排列顺序：按照下单时间由近及远排列，这里取得是子订单的创建时间。

            String sortName = SubOrder_.order.getName() + "." + OrderMain_.createTime.getName(); /*"order.createTime"*/
            Sort sort = new Sort(Sort.Direction.DESC, sortName);//dateCreated


            Pageable pageable = new PageRequest(pageNo, pageSize, sort);
            Specification specification = new QueryProviderOrdersSpecification(orderQueryDto, false);
            Page<SubOrder> page = subOrderRepos.findAll(specification, pageable);
            List<SubOrder> providerGoodsList = page.getContent();
            //PO转VO
            List<OrdersQueryVo> providerGoodsVoList = new ArrayList<>();
            providerGoodsList.stream().forEach(subOrders -> {
                OrdersQueryVo orderVo = new OrdersQueryVo();
                orderVo.setAddressName(subOrders.getOrder().getAddressName());
                orderVo.setCreatedTime(subOrders.getOrder().getCreateTime());
                List<MallShippingDto> mallShipping = mallShippingApi.findMallShipping(subOrders.getOrder().getOrderNo());
                final String[] shippingNo = {""};
                //这里还要判断这里的状态是否是在已发货之后的订单状态,否者会添加

                //if(){  //subOrders.getTrdOrderState();
                    if(!Lang.isEmpty(mallShipping)){
                        mallShipping.forEach(mallShippingDto -> {
                            if(shippingNo[0] ==""){
                                shippingNo[0] = shippingNo[0] +mallShippingDto.getShippingNo();
                            }else {
                                shippingNo[0] = shippingNo[0] +","+mallShippingDto.getShippingNo();
                            }
                        });
                    }
               // }


                orderVo.setLogisticsNo(shippingNo[0]);
                orderVo.setOrderNo(subOrders.getOrder().getOrderNo());
                orderVo.setSumCostPrice(subOrders.getSumCostPrice());
                orderVo.setTrdOrderState(subOrders.getTrdOrderState());
                orderVo.setSubOrderNo(subOrders.getSubOrderNo());
                providerGoodsVoList.add(orderVo);
            });

            PageVo<OrdersQueryVo> pageVo = new PageVo();
            pageVo.setResult(providerGoodsVoList);
            long totalElements = page.getTotalElements();
            pageVo.setTotalCount((int) totalElements);
            pageVo.setPageNum(page.getNumber());
            pageVo.setPageSize(page.getSize());

          /*  baseResponse.setResult(pageVo);
            baseResponse.setResultCode("0000"); baseResponse.setResultMessage("查询成功");
            baseResponse.setSuccess(true);*/
            baseResponse =    new BaseResponse(true, MessageDictionary.RETURN_SUCCESS_MESSAGE, pageVo, MessageDictionary.RETURN_SUCCESS_CODE);
        } catch (Exception e) {

            baseResponse = new BaseResponse(false, MessageDictionary.RETURN_INTERNAL_ERROR_MESSAGE, "", MessageDictionary.RETURN_INTERNAL_EXCEPTION_CODE);
            // baseResponse = new BaseResponse(false, "内部错误", "", "3001");
            e.printStackTrace();
        }
        return baseResponse;

    }


    /**
     * 根据id查找
     *
     * @param id
     * @return
     */
    public OrderMain getOrder(String id) {
        return Lang.isEmpty(id) ? null : orderRepos.findById(id);
    }

    /**
     * 根据订单号查找
     *
     * @param orderNo
     * @return
     */
    public OrderMain findByOrderNo(String orderNo) {
        return Lang.isEmpty(orderNo) ? null : orderRepos.findByOrderNo(orderNo);
    }

    /**
     * 根据批量订单号查找
     *
     * @param orderNos
     * @return
     */
    public List<OrderMain> findByOrderNos(List<String> orderNos) {
        return orderRepos.findByOrderNoIn(orderNos);
    }

    /**
     * 查找subOrderNos
     *
     * @param parentOrderId
     * @return
     */
    public List<CartSimpleMallOrderDto> getMallSubOrderNos(String parentOrderId) {
        OrderMain orderMainExam = new OrderMain();
        orderMainExam.setParentOrderId(parentOrderId);
        OrderMainSpecification orderMainSpecification = new OrderMainSpecification(orderMainExam);
        List<OrderMain> orderMains = orderRepos.findAll(orderMainSpecification);
        List<CartSimpleMallOrderDto> cartSimpleMallOrderDtos = new ArrayList<>();
        if (CollectionUtil.isNoneEmpty(orderMains)) {
            orderMains.forEach(orderMain -> {
                CartSimpleMallOrderDto cartSimpleMallOrderDto = new CartSimpleMallOrderDto();
                cartSimpleMallOrderDto.setOrderId(orderMain.getId());
                cartSimpleMallOrderDto.setOrderNo(orderMain.getOrderNo());
                cartSimpleMallOrderDtos.add(cartSimpleMallOrderDto);
            });
        }
        return cartSimpleMallOrderDtos;
    }

    /**
     * 根据orderKey查找（多个）
     *
     * @param orderKeys
     * @return
     */
    public List<OrderMain> findByKey(List<OrderKey> orderKeys) {
        if (orderKeys == null || orderKeys.size() <= 0) {
            return null;
        }
        // 如果所有keys里的orderId和orderNo都为空，则返回空
        if (orderKeys.stream().filter(i -> !i.isEmpty()).count() <= 0) {
            return null;
        }

        return orderRepos.findAll((root, query, cb) -> {
            List<Predicate> keyQuerys = new ArrayList<>();
            List<Predicate> orQuerys = new ArrayList<>();
            for (OrderKey key : orderKeys) {
                // 优先处理id
                if (!Lang.isEmpty(key.getOrderId())) {
                    orQuerys.add(cb.equal(root.get(OrderMain_.id), key.getOrderId()));
                } else if (!Lang.isEmpty(key.getOrderNo())) {
                    orQuerys.add(cb.equal(root.get(OrderMain_.orderNo), key.getOrderNo()));
                }
            }
            return cb.or(orQuerys.toArray(new Predicate[0]));
        });
    }

    /**
     * 根据orderKey查找（单个）
     *
     * @param orderKey
     * @return
     */
    public OrderMain findByKey(OrderKey orderKey) {
        if (orderKey == null) {
            return null;
        }

        if (Lang.isEmpty(orderKey.getOrderId()) && Lang.isEmpty(orderKey.getOrderNo())) {
            return null;
        }
        List<OrderMain> r = findByKey(new ArrayList<OrderKey>() {{
            add(orderKey);
        }});

        return r != null && r.size() > 0 ? r.get(0) : null;
    }

    /**
     * 根据订单ID查找订单号
     *
     * @param orderId 订单ID
     * @return 订单号
     */
    public String findOrderNoById(String orderId) {
        return orderRepos.findOrderNoById(orderId);
    }

    /**
     * 根据第三方订单号查找商城订单号
     *
     * @param trdOrderNo 第三方订单号
     * @return 商城订单号
     */
    public String findOrderNoByThirdOrderNo(String trdOrderNo) {
        OrderMain om = orderRepos.findByThirdOrderNo(trdOrderNo);
        return om == null ? null : om.getOrderNo();
    }
}
