package order.service.specification;

import order.model.po.OrderTemplateAdapterConfig;
import order.model.po.OrderTemplateAdapterConfig_;
import order.vo.query.OrderTemplateAdapterConfigQuery;
import utils.Lang;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.List;

/**
 * OrderTemplateAdapterConfig表的Specification
 * @author Liang Wenxu
 * @since 2018/7/10
 */
public class OrderTemplateConfigQuerySpecification extends QuerySpecification<OrderTemplateAdapterConfig, OrderTemplateAdapterConfigQuery> {
    public OrderTemplateConfigQuerySpecification(OrderTemplateAdapterConfigQuery queryInstance) {
        this(queryInstance, true);
    }

    public OrderTemplateConfigQuerySpecification(OrderTemplateAdapterConfigQuery queryInstance, Boolean ignoreNull) {
        super(queryInstance, ignoreNull);
        ignoreNullExcluded.add(OrderTemplateAdapterConfig_.id);
        ignoreNullExcluded.add(OrderTemplateAdapterConfig_.templateName);
        ignoreNullExcluded.add(OrderTemplateAdapterConfig_.templateClass);
    }

    public OrderTemplateConfigQuerySpecification(OrderTemplateAdapterConfigQuery queryInstance, Boolean ignoreNull, List<SingularAttribute> ignoreNullExcluded) {
        super(queryInstance, ignoreNull, ignoreNullExcluded);
    }

    @Override
    public Predicate toPredicate(Root<OrderTemplateAdapterConfig> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        List<Predicate> predicates = new ArrayList<>();

        if(!Lang.isEmpty(super.getQueryInstance().getId())) {
            predicates.add(cb.equal(root.get(OrderTemplateAdapterConfig_.id), super.getQueryInstance().getId()));
        } else if(!ignoreNull && !ignoreNullExcluded.contains(OrderTemplateAdapterConfig_.id)) {
            predicates.add(cb.isNull(root.get(OrderTemplateAdapterConfig_.id)));
        }

        if(!Lang.isEmpty(super.getQueryInstance().getEnabled())) {
            predicates.add(cb.equal(root.get(OrderTemplateAdapterConfig_.enabled), super.getQueryInstance().getEnabled()));
        } else if(!ignoreNull && !ignoreNullExcluded.contains(OrderTemplateAdapterConfig_.enabled)) {
            predicates.add(cb.isNull(root.get(OrderTemplateAdapterConfig_.enabled)));
        }

        if(!Lang.isEmpty(super.getQueryInstance().getGoodsType())) {
            predicates.add(cb.equal(root.get(OrderTemplateAdapterConfig_.goodsType), super.getQueryInstance().getGoodsType()));
        } else if(!ignoreNull && !ignoreNullExcluded.contains(OrderTemplateAdapterConfig_.goodsType)) {
            predicates.add(cb.isNull(root.get(OrderTemplateAdapterConfig_.goodsType)));
        }

        if(!Lang.isEmpty(super.getQueryInstance().getOrgCode())) {
            predicates.add(cb.equal(root.get(OrderTemplateAdapterConfig_.orgCode), super.getQueryInstance().getOrgCode()));
        } else if(!ignoreNull && !ignoreNullExcluded.contains(OrderTemplateAdapterConfig_.orgCode)) {
            predicates.add(cb.isNull(root.get(OrderTemplateAdapterConfig_.orgCode)));
        }

        if(!Lang.isEmpty(super.getQueryInstance().getTemplateClass())) {
            predicates.add(cb.equal(root.get(OrderTemplateAdapterConfig_.templateClass), super.getQueryInstance().getTemplateClass()));
        } else if(!ignoreNull && !ignoreNullExcluded.contains(OrderTemplateAdapterConfig_.templateClass)) {
            predicates.add(cb.isNull(root.get(OrderTemplateAdapterConfig_.templateClass)));
        }

        if(!Lang.isEmpty(super.getQueryInstance().getTemplateName())) {
            predicates.add(cb.equal(root.get(OrderTemplateAdapterConfig_.templateName), super.getQueryInstance().getTemplateName()));
        } else if(!ignoreNull && !ignoreNullExcluded.contains(OrderTemplateAdapterConfig_.templateName)) {
            predicates.add(cb.isNull(root.get(OrderTemplateAdapterConfig_.templateName)));
        }

        if(!Lang.isEmpty(super.getQueryInstance().getIsDelete())) {
            predicates.add(cb.equal(root.get(OrderTemplateAdapterConfig_.isDelete), super.getQueryInstance().getIsDelete()));
        } else if(!ignoreNull && !ignoreNullExcluded.contains(OrderTemplateAdapterConfig_.isDelete)) {
            predicates.add(cb.isNull(root.get(OrderTemplateAdapterConfig_.isDelete)));
        }

        if(!Lang.isEmpty(super.getQueryInstance().getOrderMode())) {
            predicates.add(cb.equal(root.get(OrderTemplateAdapterConfig_.orderMode), super.getQueryInstance().getOrderMode()));

        } else if(!ignoreNull && !ignoreNullExcluded.contains(OrderTemplateAdapterConfig_.orderMode)) {
            predicates.add(cb.isNull(root.get(OrderTemplateAdapterConfig_.orderMode)));
        }

        return query.where(predicates.toArray(new Predicate[predicates.size()])).getRestriction();
    }
}
