package order.service.specification;

import cart.api.difinication.TrdSpOrderStatus;
import order.dto.OrderQueryDto;
import order.model.po.OrderMain_;
import order.model.po.OrderTemplateAdapterConfig_;
import order.model.po.SubOrder;
import order.model.po.SubOrder_;
import utils.Lang;

import javax.persistence.criteria.*;
import javax.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * SUB_ORDER表的Specification
 *
 * @author xjw
 * @since 2018年9月7日 10:27:30
 */
public class QueryProviderOrdersSpecification extends QuerySpecification<SubOrder, OrderQueryDto> {
    public QueryProviderOrdersSpecification(OrderQueryDto queryInstance) {
        this(queryInstance, true);
    }

    public QueryProviderOrdersSpecification(OrderQueryDto queryInstance, Boolean ignoreNull) {
        super(queryInstance, ignoreNull);
        ignoreNullExcluded.add(OrderTemplateAdapterConfig_.id);
    }

    public QueryProviderOrdersSpecification(OrderQueryDto queryInstance, Boolean ignoreNull, List<SingularAttribute> ignoreNullExcluded) {
        super(queryInstance, ignoreNull, ignoreNullExcluded);
    }

    @Override
    public Predicate toPredicate(Root<SubOrder> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {

        Date beginTime = super.getQueryInstance().getBeginTime();
        Date endTime = super.getQueryInstance().getEndTime();

        List<Predicate> predicates = new ArrayList<>();
        if (!Lang.isEmpty(super.getQueryInstance())) {

            /**  店铺ID (必须传)*/
            if (!Lang.isEmpty(super.getQueryInstance().getStoreId())) {
                predicates.add(criteriaBuilder.equal(root.join(SubOrder_.order, JoinType.LEFT).get(OrderMain_.storeId), super.getQueryInstance().getStoreId()));
            }
            /**  订单号 (非必须传) */
            /**    性能考虑，订单号：暂时不支持模糊查询*/
            if (!Lang.isEmpty(super.getQueryInstance().getOrderNo())) {
                predicates.add(criteriaBuilder.equal(root.join(SubOrder_.order, JoinType.LEFT).get(OrderMain_.orderNo), super.getQueryInstance().getOrderNo()));
            }
        }
        /**   订单状态 */
        if (!Lang.isEmpty(super.getQueryInstance().getTrdOrderState())) {

            if (!TrdSpOrderStatus.All.getCode().equals(super.getQueryInstance().getTrdOrderState()) && !TrdSpOrderStatus.Canceled.getCode().equals(super.getQueryInstance().getTrdOrderState()))
                predicates.add(criteriaBuilder.equal(root.get(SubOrder_.trdOrderState), super.getQueryInstance().getTrdOrderState()));
            //说明-这里的 "3" 就是泛指的已取消，系统已取消 状态9  和买家已取消6 状态  //3 OR 9 条件组合
            if (TrdSpOrderStatus.Canceled.getCode().equals(super.getQueryInstance().getTrdOrderState()))
                predicates.add(criteriaBuilder.or(criteriaBuilder.equal(root.get(SubOrder_.trdOrderState), super.getQueryInstance().getTrdOrderState()), criteriaBuilder.equal(root.get("trdOrderState"), TrdSpOrderStatus.SystemCanceled.getCode())));
        }
        /**  时间范围 */
        if (!Lang.isEmpty(beginTime) && !Lang.isEmpty(endTime)) {

            Date endDate = new Date(endTime.getTime() + 999);
            predicates.add(criteriaBuilder.between(root.get(SubOrder_.order).get(OrderMain_.createTime), beginTime, endDate));
        } else if (!Lang.isEmpty(beginTime) && Lang.isEmpty(endTime)) {
            predicates.add(criteriaBuilder.greaterThan(root.get(SubOrder_.order).get(OrderMain_.createTime), beginTime));
        } else if (Lang.isEmpty(beginTime) && !Lang.isEmpty(endTime)) {
            predicates.add(criteriaBuilder.lessThan(root.get(SubOrder_.order).get(OrderMain_.createTime), endTime));
        }

        //添加isDelete=false的限制
        predicates.add(criteriaBuilder.equal(root.get(SubOrder_.isDelete), false)); //逻辑删除 true：删除，false：未删除
        return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
    }
}
