package order.service.specification;

import lombok.Data;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.List;

/**
 * Specification抽象类
 * @author Liang Wenxu
 * @since 2018/7/10
 */
@Data
public abstract class QuerySpecification<T, QUERY> implements Specification<T> {
    /**
     * 查询对象
     */
    protected QUERY queryInstance;
    /**
     * 是否忽略空控制，当此参数为true，则当查询参数中为null的属性，会执行is null查询
     */
    protected Boolean ignoreNull;
    /**
     * 当ignoreNull为true时有意义，存在于排除列表中的字段，将不会受ignoreNull的影响，当为空时不会拼接is null约束
     */
    protected List<SingularAttribute> ignoreNullExcluded = new ArrayList<>();

    public QuerySpecification(QUERY queryInstance) {
        this.queryInstance = queryInstance;
        this.ignoreNull = true;
    }

    public QuerySpecification(QUERY queryInstance, Boolean ignoreNull) {
        this.queryInstance = queryInstance;
        this.ignoreNull = ignoreNull;
    }

    public QuerySpecification(QUERY queryInstance, Boolean ignoreNull, List<SingularAttribute> ignoreNullExcluded) {
        this.queryInstance = queryInstance;
        this.ignoreNull = ignoreNull;
        this.ignoreNullExcluded = ignoreNullExcluded;
    }
}
