package order.service.stubs;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import lombok.extern.slf4j.Slf4j;
import member.api.CoreCompDepartUserApi;
import member.api.dto.core.CoreCompDepartUserDto;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.core.CoreUserDto;
import member.api.vo.CoreCompDepartUserVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.sql.PageVo;

import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2018/8/3
 */
@Slf4j
@Component
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class CoreCompDepartUserApiStub {
    /**
     * ID 查找
     *
     * @param id 记录id值
     * @param isDelete
     * @return CoreCompDepartUser，根据传入的id，返回相应的用户机构部门信息
     */
    public CoreCompDepartUserDto findByIdAndIsDelete(String id, boolean isDelete) {
        return coreCompDepartUserApi.findByIdAndIsDelete(id, isDelete);
    }

    /**
     * Example查询，返回关联表实体集合vo
     *
     * @param examp 查询匹配条件，具体实体请查询->
     * @return List<CoreCompDepartUserVo>,根据example匹配条件，返回相应的用户机构部门信息列表，具体返回VO请查询->
     * @see CoreCompDepartUserVo
     */
    public List<CoreCompDepartUserVo> findRelatedVoByExample(CoreCompDepartUserDto examp) {
        return coreCompDepartUserApi.findRelatedVoByExample(examp);
    }

    /**
     * Example查询,查询用户机构部门关联信息列表
     *
     * @param examp 匹配条件，具体请求实体请查询->
     * @return List<CoreCompDepartUser>，根据传入的请求参数，返回相应的用户机构部门关联信息列表
     */
    public List<CoreCompDepartUserDto> findByExample(CoreCompDepartUserDto examp) {
        return coreCompDepartUserApi.findByExample(examp);
    }

    /**
     * Example查询(带分页)
     *
     * @param examp    匹配条件，具体请求实体请查询->
     * @param pageable 分页参数
     * @return Page<CoreCompDepartUser>，根据匹配条件，返回相应的用户机构部门关联信息列表，带分页
     */
    public Page<CoreCompDepartUserDto> findByExample(CoreCompDepartUserDto examp, Pageable pageable) {
        return coreCompDepartUserApi.findByExample(examp, pageable);
    }

    /**
     * 根据用户id，查询相应的用户机构部门关联信息VO列表
     *
     * @param userId 用户id
     * @return List<CoreCompDepartUserVo>，根据传入的用户id，返回相应的用户机构部门详细信息VO
     */
    public List<CoreCompDepartUserVo> findRelatedVoByUser(String userId) {
        return coreCompDepartUserApi.findRelatedVoByUser(userId);
    }

    /**
     * 获取用户关联的机构
     *
     * @param userId 用户id
     * @return List<CoreCompany>，根据传入的用户id返回该用户关联的机构信息列表
     */
    public List<CoreCompanyDto> getUserRelatedCompany(String userId) {
        return coreCompDepartUserApi.getUserRelatedCompany(userId);
    }

    /**
     * 获取用户的采购员职位所属机构
     *
     * @param userId 用户id
     * @return CoreCompany，根据用户id，返回该用户的采购员职位所属机构信息
     */
    public CoreCompanyDto getBuyerCompany(String userId) {
        return coreCompDepartUserApi.getBuyerCompany(userId);
    }

    /**
     * 获取指定职位的组织机构
     *
     * @param userId
     * @param position
     * @return
     */
    public CoreCompanyDto getCompanyByUserIdAndPositon(String userId, String position) {
        return coreCompDepartUserApi.getCompanyByUserIdAndPositon(userId, position);
    }

    /**
     * 获取用户对应职位所属的机构
     *
     * @param userId 用户id
     * @param prostionCode
     * @return List<CoreCompany>，根据传入的用户id，职位编码，返回相应的机构信息列表
     */
    public List<CoreCompanyDto> getUserProstionCompany(String userId, String prostionCode) {
        return coreCompDepartUserApi.getUserProstionCompany(userId, prostionCode);
    }

    /**
     * 根据机构id查询相应的用户机构部门关联信息
     *
     * @param CompanyId 机构id
     * @return List<CoreCompDepartUser>，根据传入的机构id，返回相应的用户机构部门关联信息列表
     */
    public List<CoreCompDepartUserDto> findAllByCompanyId(String CompanyId) {
        return coreCompDepartUserApi.findAllByCompanyId(CompanyId);
    }

    /**
     * 查询机构对应的用户机构部门关联信息列表
     *
     * @param CompanyId 机构id
     * @param isdelete  是否删除
     * @return List<CoreCompDepartUser>，根据传入的机构id，返回相应机构关联的用户机构部门关联信息列表
     */
    public List<CoreCompDepartUserDto> findAllByCompanyIdAndIsDelete(String CompanyId, boolean isdelete) {
        return coreCompDepartUserApi.findAllByCompanyIdAndIsDelete(CompanyId, isdelete);
    }

    /**
     * 查询机构对应的且部门id为空的用户机构部门关联信息列表
     *
     * @param id       机构id
     * @param isdelete 是否删除
     * @return List<CoreCompDepartUser>，根据传入的机构id，返回相应机构关联的用户机构部门关联信息列表
     */
    public List<CoreCompDepartUserDto> findAllByCompanyIdAndIsDeleteAndDepartmentIdIsNull(String id, boolean isdelete) {
        return coreCompDepartUserApi.findAllByCompanyIdAndIsDeleteAndDepartmentIdIsNull(id, isdelete);
    }

    /**
     * 查询部门id对应的用户机构部门关联信息列表
     *
     * @param DepartmentId 部门id
     * @return List<CoreCompDepartUser>，根据传入的部门id，返回相应部门关联的用户机构部门关联信息列表
     */
    public List<CoreCompDepartUserDto> findAllByDepartmentId(String DepartmentId) {
        return coreCompDepartUserApi.findAllByDepartmentId(DepartmentId);
    }

    /**
     * 查询部门id对应的用户机构部门关联信息列表
     *
     * @param id       部门id
     * @param isdelete 是否删除
     * @return List<CoreCompDepartUser>，根据传入的部门id，返回相应部门关联的用户机构部门关联信息列表
     */
    public List<CoreCompDepartUserDto> findAllByDepartmentIdAndIsDelete(String id, boolean isdelete) {
        return coreCompDepartUserApi.findAllByDepartmentIdAndIsDelete(id, isdelete);
    }

    /**
     * 查询用户对应的用户机构部门关联信息列表
     *
     * @param userId 用户id
     * @return List<CoreCompDepartUser>，根据传入的用户id，返回该用户关联的用户机构部门关联信息列表
     */
    public List<CoreCompDepartUserDto> findByUserId(String userId) {
        return coreCompDepartUserApi.findByUserId(userId);
    }

    /**
     * 查询用户机构部门关联信息，带分页
     *
     * @param userName  用户名
     * @param realName  真实姓名
     * @param companyId 机构id
     * @param andMore   包含子机构
     * @param power     权限
     * @param pageable  分页参数
     * @return PageVo，根据查询参数，返回相应的用户机构部门关联信息VO，含分页
     */
    public PageVo findCoreCompDepartUserByParams(String userName, String realName, String companyId, String andMore, String power, Pageable pageable) {
        return coreCompDepartUserApi.findCoreCompDepartUserByParams(userName, realName, companyId, andMore, power, pageable);
    }

    /**
     * 查询用户机构部门关联信息
     *
     * @param companyId      机构id
     * @param whetherAuditor 是否审核人
     * @param isDelete       是否删除
     * @return List<CoreCompDepartUser>，根据传入的机构id，及是否审核员，返回相应的用户机构部门关联信息列表
     */
    public List<CoreCompDepartUserDto> findByCompanyIdAndWhetherAuditorAndIsDelete(String companyId, Boolean whetherAuditor, boolean isDelete) {
        return coreCompDepartUserApi.findByCompanyIdAndWhetherAuditorAndIsDelete(companyId, whetherAuditor, isDelete);
    }

    /**
     * 查询用户机构部门关联信息
     *
     * @param companyId      机构id
     * @param whetherAuditor 是否审核员
     * @param isDelete       是否删除
     * @return List<CoreCompDepartUser>，根据传入的机构id，是否审核，返回部门id为空的相应的用户机构部门关联信息列表
     */
    public List<CoreCompDepartUserDto> findByCompanyIdAndWhetherAuditorAndIsDeleteAndDepartmentIdIsNull(String companyId, Boolean whetherAuditor, boolean isDelete) {
        return coreCompDepartUserApi.findByCompanyIdAndWhetherAuditorAndIsDeleteAndDepartmentIdIsNull(companyId, whetherAuditor, isDelete);
    }

    /**
     * 根据部门id查询相应的用户机构部门关联信息
     *
     * @param companyId      机构id
     * @param whetherAuditor 是否审核员
     * @param isDelete       是否删除
     * @return List<CoreCompDepartUser>，根据传入的部门id及是否审核员，返回相应的用户机构部门关联信息列表
     */
    public List<CoreCompDepartUserDto> findByDepartmentIdAndWhetherAuditorAndIsDelete(String companyId, Boolean whetherAuditor, boolean isDelete) {
        return coreCompDepartUserApi.findByDepartmentIdAndWhetherAuditorAndIsDelete(companyId, whetherAuditor, isDelete);
    }

    /**
     * 根据用户id返回相应的用户机构部门关联信息列表
     *
     * @param user_id  用户id
     * @param isDelete 是否删除
     * @return List<CoreCompDepartUser>，根据传入的用户id，返回用户相关联的用户机构部门关联信息列表
     */
    public List<CoreCompDepartUserDto> findByUserIdAndIsDelete(String user_id, boolean isDelete) {
        return coreCompDepartUserApi.findByUserIdAndIsDelete(user_id, isDelete);
    }

    /**
     * 根据机构id列表，查询相应的用户机构部门关联信息列表
     *
     * @param companyIds 机构id列表
     * @return List<CoreCompDepartUser>，根据传入的机构id列表，顺序返回相应的用户机构部门关联信息列表
     */
    public List<CoreCompDepartUserDto> findByCompanyIdList(List<String> companyIds) {
        return coreCompDepartUserApi.findByCompanyIdList(companyIds);
    }

    /**
     * 根据机构id列表查询相应的机构信息
     *
     * @param companyIdList 机构id列表
     * @return List<CoreCompany>，根据传入的机构id列表，顺序返回相应的机构信息列表
     */
    public List<CoreCompanyDto> findByCompanyIds(List<String> companyIdList) {
        return coreCompDepartUserApi.findByCompanyIds(companyIdList);
    }

    public CoreUserDto findByCompanyIdAndRoleCode(String companyId, String roleId) {
        return coreCompDepartUserApi.findByCompanyIdAndRoleCode(companyId, roleId);
    }

    /**
     * 根据自定义条件查询符合条件的
     *
     * @param coreCompDepartUserDto
     * @return
     */
    public List<CoreCompDepartUserDto> findAll(CoreCompDepartUserDto coreCompDepartUserDto) {
        return coreCompDepartUserApi.findAll(coreCompDepartUserDto);
    }

    /**
     * 根据userId获取机构列表（不包含child属性）
     *
     * @param userId
     * @return
     */
    public List<CoreCompanyDto> findCompanyByUserId(String userId) {
        return coreCompDepartUserApi.findCompanyByUserId(userId);
    }

    /**
     * @author taofeng
     * @date 2018/5/15
     * <p>
     * 获取指定机构指定职位的CoreCompDepartUser
     * @param companyId
     * @param positionCode
     */
    public BaseResponse<List<CoreUserDto>> findByCompanyIdAndPositionId(String companyId, String positionCode) {
        return coreCompDepartUserApi.findByCompanyIdAndPositionId(companyId, positionCode);
    }

    public BaseResponse<List<String>> findByCompanyIdAndPositionId(List<String> companyId, String positionCode) {
        return coreCompDepartUserApi.findByCompanyIdAndPositionId(companyId, positionCode);
    }

    @MotanReferer
    CoreCompDepartUserApi coreCompDepartUserApi;
}
