package order.service.stubs;

import activities.api.GroupBuyingApi;
import activities.dto.activity.request.OrderRequstVo;
import activities.dto.activity.response.OrderResponseVo;
import activities.dto.groupbuying.request.*;
import activities.dto.groupbuying.response.*;
import activities.vo.payment.PaymentReturnVo;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import sinomall.config.api.base.BaseResponse;

/**
 * @author Liang Wenxu
 * @since 2018/8/30
 */
@Component
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class GroupBuyingApiStub {
    /**
     * 查询拼团商品价格
     *
     * @param groupBuyingGoodsReqDto
     * @return
     */
    public GroupBuyingGoodsRespDto queryGroupBuyingGoodsPrice(GroupBuyingGoodsReqDto groupBuyingGoodsReqDto) {
        return groupBuyingApi.queryGroupBuyingGoodsPrice(groupBuyingGoodsReqDto);
    }

    /**
     * 查询团信息
     *
     * @param gbGroupInfoReqDto
     * @return
     */
    public GbGroupInfoRespDto queryGbGroupInfo(GbGroupInfoReqDto gbGroupInfoReqDto) {
        return groupBuyingApi.queryGbGroupInfo(gbGroupInfoReqDto);
    }

    /**
     * 查询活动信息
     * @param gbActivityInfoReqDto
     */
    public GbActivityInfoRespDto queryGbActivityInfoById(GbActivityInfoReqDto gbActivityInfoReqDto) {
        return groupBuyingApi.queryGbActivityInfoById(gbActivityInfoReqDto);
    }

    /**
     * 根据活动或团查询参团数量以及是否做过此活动团长
     *
     * @param gbGroupJoinReqDto
     * @return
     */
    public GbGroupJoinRespDto queryGbGroupJoinNumber(GbGroupJoinReqDto gbGroupJoinReqDto) {
        return groupBuyingApi.queryGbGroupJoinNumber(gbGroupJoinReqDto);
    }

    /**
     * 拼团活动创建订单
     *
     * @param orderRequstVo
     * @return
     */
    public OrderResponseVo createOrder(OrderRequstVo orderRequstVo) {
        return groupBuyingApi.createOrder(orderRequstVo);
    }

    /**
     * 处理拼团团信息，根据购买方式创建新团或
     *
     * @param hanleGroupRequestDto
     * @return
     */
    public GroupInfoHandleResponseDto handleGroupInfo(GroupInfoHandleRequestDto hanleGroupRequestDto) {
        return groupBuyingApi.handleGroupInfo(hanleGroupRequestDto);
    }

    /**
     * 取消拼团订单
     *
     * @param orderNo
     * @return
     */
    public BaseResponse cancelGbOrder(String orderNo) {
        return groupBuyingApi.cancelGbOrder(orderNo);
    }

    /**
     * 拼团支付回调
     *
     * @param paymentReturnVo
     * @return
     */
    public BaseResponse gbPayback(PaymentReturnVo paymentReturnVo) {
        return groupBuyingApi.gbPayback(paymentReturnVo);
    }

    public GbOrderInfoDto queryGroupOrderInfo(String orderNo) {
        return groupBuyingApi.queryGroupOrderInfo(orderNo);
    }

    public String findOrderNoByMemberIdAndGroupId(String memberId, String groupId) {
        return groupBuyingApi.findOrderNoByMemberIdAndGroupId(memberId, groupId);
    }

    /**
     * 定时扫描处理过期未成团的团
     * */
    public void queryActivityGroupStatusAndHandle() {
        groupBuyingApi.queryActivityGroupStatusAndHandle();
    }

    @MotanReferer
    GroupBuyingApi groupBuyingApi;
}
