package order.service.stubs;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import lombok.extern.slf4j.Slf4j;
import member.api.MemberAddressApi;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.ValidataMemberAddress;
import member.api.vo.ValidateInvoiceAddress;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * MemberAddressApi本地代理
 * @author Liang Wenxu
 * @since 2018/7/27
 */
@Slf4j
@Component
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class MemberAddressApiStub {
    /**
     * 查询会员所有地址信息
     * @param memberId 会员id
     * @return List<MemberAddress>，根据传入的会员id，返回该会员具有的地址信息列表
     */
    public List<MemberAddressDto> list(String memberId) {
        return memberAddressApi.list(memberId);
    }

    /**
     * 查询会员默认地址信息
     * @param memberId 会员id
     * @return MemberAddress, 根据传入的会员id，返回相应的会员默认地址信息
     */
    public MemberAddressDto defaultAddress(String memberId) {
        return memberAddressApi.defaultAddress(memberId);
    }

    /**
     * 查询某个类别下的默认地址信息
     * @param memberId 会员id
     * @param type 类型，如jd ,suling 等
     * @return MemberAddress，根据传入的参数，返回相应的地址信息
     */
    public MemberAddressDto defaultAddress(String memberId, String type) {
        return memberAddressApi.defaultAddress(memberId, type);
    }

    /**
     * 根据地址id，查询相应的地址信息
     * @param id 地址id
     * @return MemberAddress, 根据传入的地址id，返回相应的地址信息
     */
    public MemberAddressDto findById(String id) {
        return memberAddressApi.findById(id);
    }

    /**
     * 查询实际商品地址
     * @param virtualAddreess
     * @return MemberAddress，返回地址信息
     */
    public MemberAddressDto findVirtualGoodsAddress(String virtualAddreess) {
        return memberAddressApi.findVirtualGoodsAddress(virtualAddreess);
    }

    /**
     * 根据地址id,查询地址信息
     * @param addrId 地址id
     * @param b 是否删除
     * @return MemberAddress，根据传入的参数，返回相应的地址信息
     */
    public MemberAddressDto findByIdAndIsDelete(String addrId, boolean b) {
        return memberAddressApi.findByIdAndIsDelete(addrId, b);
    }

    public MemberAddressDto findDtoByIdAndIsDelete(String addressId, boolean b) {
        return memberAddressApi.findDtoByIdAndIsDelete(addressId, b);
    }

    /**
     * 批量查询订单地址，key为memberAddressId
     * @param memberAddressIds
     * @return
     */
    public Map<String, MemberAddressDto> findByIds(List<String> memberAddressIds) {
        return memberAddressApi.findByIds(memberAddressIds);
    }

    /**
     * 根据上传地址信息查询会员地址信息
     * @param memberAddressDto
     */
    public MemberAddressDto findByAddressInfo(MemberAddressDto memberAddressDto) {
        return memberAddressApi.findByAddressInfo(memberAddressDto);
    }

    /**
     * 根据地址编号,memberId查询用户地址信息
     * @param addressNo
     * @param memberId
     * @return
     */
    public MemberAddressDto findByAddressNoAndIsDelete(String addressNo, String memberId) {
        return memberAddressApi.findByAddressNoAndIsDelete(addressNo, memberId);
    }

    /**
     * 获取用户常用地址
     * @param memberId
     * @return
     */
    public List<MemberAddressDto> findByMemberId(String memberId) {
        return memberAddressApi.findByMemberId(memberId);
    }

    /**
     * 直购批量导入地址批量校验
     * @param list
     * @return
     */
    public Map validataMemberAddress(List<ValidataMemberAddress> list) {
        return memberAddressApi.validataMemberAddress(list);
    }

    /**
     * 直购批量导入发票地址批量校验
     * @param list
     * @return
     */
    public Map validataInvoiceAddress(List<ValidateInvoiceAddress> list) {
        return memberAddressApi.validataInvoiceAddress(list);
    }

    @MotanReferer
    MemberAddressApi memberAddressApi;
}
