package order.service.stubs;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import store.api.StoreApi;
import store.api.dto.mapdto.UnreviewedStoreDto;
import store.api.dto.modeldto.core.StoreDto;
import store.api.dto.modeldto.core.StoreExtDto;

import java.util.List;
import java.util.Map;

/**
 * @author Liang Wenxu
 * @since 2018/8/3
 */
@Slf4j
@Component
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class StoreApiStub {
    /**
     * 获取供应商信息
     *
     * @author taofeng
     * @date 2018/3/19
     *
     * @param type*/
    public List<StoreDto> findByTpye(String type) {
        return storeApi.findByTpye(type);
    }

    /**
     * 根据店铺ID获得店铺信息
     *
     * @param storeId 店铺id
     * @return Store, 按传入的店铺id，返回店铺信息
     */
    public StoreDto findByStoreId(String storeId) {
        return storeApi.findByStoreId(storeId);
    }

    /**
     * 批量查找店铺信息
     *
     * @param storeIds 店铺id列表
     * @return List<Store>，根据传入的店铺id顺序返回相应的店铺列表
     */
    public List<StoreDto> findByStoreIds(List<String> storeIds) {
        return storeApi.findByStoreIds(storeIds);
    }

    /**
     * 根据店铺ID获得店铺信息
     *
     * @param storeId 店铺id
     * @return Store, 按传入的店铺id，返回店铺信息
     */
    public StoreDto getStoreInfo(String storeId) {
        return storeApi.getStoreInfo(storeId);
    }

    /**
     * 查询所有可用的店铺信息列表
     *
     * @return List<StoreDto>，返回所有可用的店铺列表
     */
    public List<StoreDto> getStoreList() {
        return storeApi.getStoreList();
    }

    /**
     * 查询所有可用的店铺信息列表
     *
     * @return List<Store>，返回所有可用的店铺列表
     */
    public List<StoreDto> findStoreList() {
        return storeApi.findStoreList();
    }

    /**
     * 根据店铺名称分页查找店铺
     *
     * @param name     店铺名称
     * @param pageable 分页信息
     * @return Map，根据店铺名称以及分页参数，返回相应的店铺信息
     */
    public UnreviewedStoreDto getUnreviewedStores(String name, Pageable pageable) {
        return storeApi.getUnreviewedStores(name, pageable);
    }

    /**
     * 通过StoreExt加载StoreVo
     *
     * @param storeExt 店铺拓展属性，请求实体查询：
     * @return Map，根据传入的店铺拓展信息，返回相应的店铺Vo
     */
    public Map loadStoreVoByStoreExt(StoreExtDto storeExt) {
        return storeApi.loadStoreVoByStoreExt(storeExt);
    }

    /**
     * 获取首页展示店铺列表
     *
     * @return Map<String               ,               List               <               Store>>，根据店铺层级，返回集团级、公司级、二级机构的店铺信息列表
     */
    public Map<String, List<StoreDto>> listStoreForIndex() {
        return storeApi.listStoreForIndex();
    }

    /**
     * 根据MemberId找到对应的店铺
     *
     * @param memberId 店铺管理员id
     * @return Store, 根据店铺管理员id，返回对应的店铺
     */
    public List<StoreDto> findStoreByMember(String memberId) {
        return storeApi.findStoreByMember(memberId);
    }

    /**
     * 获取所有店铺的id,名称，通过map存储
     *
     * @return Map，返回所有店铺的id,名称map,返回数据示例->
     * {07247ea5-f2bf-4b7e-9ce4-f138a496c339=京东旗舰店，...}
     */
    public Map listToMap() {
        return storeApi.listToMap();
    }

    /**
     * 获取店铺的Code
     *
     * @param storeId 店铺id
     * @return String，根据店铺id，返回相应店铺代码
     */
    public String getStoreCode(String storeId) {
        return storeApi.getStoreCode(storeId);
    }

    /**
     * 查询上架并审核通过的店铺列表
     *
     * @return List<Store>，返回上架且审核通过的店铺列表
     */
    public List<StoreDto> findPassStore() {
        return storeApi.findPassStore();
    }

    /**
     * 通过StoreExt的code字段查找Store
     *
     * @param code 店铺代码
     * @return
     */
    public StoreDto findByCode(String code) {
        return storeApi.findByCode(code);
    }

    /**
     * 根据MemberID获取有权限管理的ID列表
     *
     * @param memberId
     * @return
     */
    public List<String> getMemberStoreIds(String memberId) {
        return storeApi.getMemberStoreIds(memberId);
    }

    /**
     * 获取 storeId
     *
     * @param storeCode storeCode
     * @return String
     */
    public String findStoreIdByCode(String storeCode) {
        return storeApi.findStoreIdByCode(storeCode);
    }

    /**
     * 获取 storeCode
     *
     * @param id id
     * @return String
     */
    public String findStoreCodeById(String id) {
        return storeApi.findStoreCodeById(id);
    }

    /**
     * 跟据供应商dVendorId查询供应商
     *
     * @param dVendorId
     * @return
     */
    public StoreDto findByDVendorId(String dVendorId) {
        return storeApi.findByDVendorId(dVendorId);
    }

    /**
     * 获取店铺名称
     *
     * @param id
     * @return String
     */
    public String findStoreNameById(String id) {
        return storeApi.findStoreNameById(id);
    }

    /**
     * @author taofeng
     * @date 2018/6/8
     * <p>
     * 根据StoreId获取StoreExt的Type
     * @param storeId
     */
    public String findStoreExtType(String storeId) {
        return storeApi.findStoreExtType(storeId);
    }

    @MotanReferer
    StoreApi storeApi;
}
