package order.service.stubs;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import sysmg.SystemConfigQueryDto;
import sysmg.api.SystemConfigApi;
import sysmg.response.SystemConfigValueDto;

import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2018/8/10
 */
@Component
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class SystemConfigApiStub {
    /**
     * 获取系统配置信息
     *
     * @param organizationCode 渠道商代码
     * @param configCode       配置参数代码
     * @param configValueType  配置值类型
     * @param isLongTerm       是否长期有效
     * @param validStatus      有效状态
     * @return String，根据请求参数，返回相应的配置值
     */
    public String getConfigValue(String organizationCode, String configCode, String configValueType, Boolean isLongTerm, Boolean validStatus) {
        return systemConfigApi.getConfigValue(organizationCode, configCode, configValueType, isLongTerm, validStatus);
    }

    /**
     * 获取系统配置信息
     *
     * @param organizationCode 渠道商代码
     * @param configCode       配置参数代码
     * @param configValueType  配置值类型
     * @param isLongTerm       是否长期有效
     * @param validStatus      有效状态
     * @param useCache         是否使用缓存
     * @return String，根据请求参数，返回相应的配置值
     */
    public String getConfigValue(String organizationCode, String configCode, String configValueType, Boolean isLongTerm, Boolean validStatus, Boolean useCache) {
        return systemConfigApi.getConfigValue(organizationCode, configCode, configValueType, isLongTerm, validStatus, useCache);
    }

    public List<SystemConfigValueDto> querySystemValues(SystemConfigQueryDto systemConfigQueryDto) {
        return systemConfigApi.querySystemValues(systemConfigQueryDto);
    }

    @MotanReferer
    SystemConfigApi systemConfigApi;
}
