package order.service.stubs;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import sysmg.api.SystemLogApi;
import sysmg.dto.SystemLogDto;

import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2018/8/30
 */
@Component
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class SystemLogApiStub {
    /**
     * 批量保存日志信息
     * @param systemLogList 待保存的日志信息列表
     * @return
     */
    public void saveBeans(List<SystemLogDto> systemLogList) {
        systemLogApi.saveBeans(systemLogList);
    }

    /**
     * 根据ID查询日志信息
     * @param sysLogId 日志id
     * @return SystemLog，根据日志id，返回系统日志信息
     */
    public SystemLogDto findById(String sysLogId) {
        return systemLogApi.findById(sysLogId);
    }

    /**
     * 单个保存日志信息，并返回保存实体
     * @param systemLog 待保存的日志信息，具体实体请查询->
     * @see SystemLogDto
     * @return SystemLog，返回保存后的日志信息
     */
    public SystemLogDto saveBean(SystemLogDto systemLog) {
        return systemLogApi.saveBean(systemLog);
    }

    public void saveAndFlush(SystemLogDto systemLogDto) {
        systemLogApi.saveAndFlush(systemLogDto);
    }

    @MotanReferer
    SystemLogApi systemLogApi;


}
