package suning.service.apiImpl;

import com.alibaba.fastjson.JSON;
import com.suning.api.entity.govbus.*;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import pool.dto.ProviderGoodsDto;
import suning.api.SnCommonConvertApi;
import suning.service.service.*;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

/**
 * Created by Roney on 2017-04-20.
 * 苏宁调用service转换数据API
 */
@MotanService(basicService = "motanServerBasicConfig")
public class SnCommonConvertApiImpl implements SnCommonConvertApi {

    private final static Log log = Logs.getLog(SnCommonConvertApiImpl.class.getName());


    @Autowired
    PreDepositBalanceService preDepositBalanceService;

    @Autowired
    SnAddressService snAddressService;

    @Autowired
    SnInvoiceService snInvoiceService;

    @Autowired
    SnMessageService snMessageService;

    @Autowired
    SnOrderService snOrderService;

    @Autowired
    SnPriceService snPriceService;

    @Autowired
    SnProdService snProdService;

    @Autowired
    SnShippingService snShippingService;

    @Autowired
    SnStockService snStockService;

    @Autowired
    ApplicationContext applicationContext;

    @Override
    public List<Map<String, String>> queryGoodsMprodStock(List<Map<String, String>> paramList, String cityId) {
        return snStockService.queryGoodsMprodStock(paramList,cityId);
    }

    @Override
    public List<Map<String, String>> getGoodsInventory(List<Map<String, String>> paramList, String cityId, String countyId) {
        return snStockService.getGoodsInventory(paramList,cityId,countyId);
    }

    @Override
    public List<Map<String, String>> getBatchProdSaleStatus(List<Map<String, String>> paramList) {
        return snProdService.getBatchProdSaleStatus(paramList);
    }

    @Override
    public List<Map<String, String>> queryGoodsPrice(List<Map<String, String>> priceParam, String cityId) {
        return snPriceService.queryGoodsPrice(priceParam, cityId);
    }

    @Override
    public String addOrder(String requestJson) {
        OrderAddRequest orderAddRequest = JSON.parseObject(requestJson, OrderAddRequest.class);
        Map resMap = snOrderService.addOrder(orderAddRequest);
        if(!Lang.isEmpty(resMap)) {
            OrderAddResponse orderAddResponse = (OrderAddResponse) resMap.get(SnOrderService.RETURN_MAP_KEY_RESULT);
            if(!Lang.isEmpty(orderAddResponse)) {
                return JSON.toJSONString(orderAddResponse);
            }
        }

        return null;
    }

    @Override
    public String addConfirmOrder(String requestJson) {
        ConfirmOrderAddRequest confirmOrderAddRequest = JSON.parseObject(requestJson, ConfirmOrderAddRequest.class);
        Map resMap = snOrderService.addConfirmOrder(confirmOrderAddRequest);
        if(!Lang.isEmpty(resMap)) {
            ConfirmOrderAddResponse confirmOrderAddResponse = (ConfirmOrderAddResponse) resMap.get(SnOrderService.RETURN_MAP_KEY_RESULT);
            if(!Lang.isEmpty(confirmOrderAddResponse)) {
                return JSON.toJSONString(confirmOrderAddResponse);
            }
        }
        return null;
    }

    @Override
    public String cancelOrder(String requestJson) {
        RejectOrderDeleteRequest rejectOrderDeleteRequest = JSON.parseObject(requestJson, RejectOrderDeleteRequest.class);
        Map resMap = snOrderService.deleteRejectOrder(rejectOrderDeleteRequest);
        if(!Lang.isEmpty(resMap)) {
            RejectOrderDeleteResponse rejectOrderDeleteResponse = (RejectOrderDeleteResponse) resMap.get(SnOrderService.RETURN_MAP_KEY_RESULT);
            if(!Lang.isEmpty(rejectOrderDeleteResponse)) {
                return JSON.toJSONString(rejectOrderDeleteResponse);
            }
        }
        return null;
    }

    @Override
    public String getShipTime(String requestJson) {
        if(!Lang.isEmpty(requestJson)) {
            ShipTimeGetRequest shipTimeGetRequest = JSON.parseObject(requestJson, ShipTimeGetRequest.class);
            Map resMap = snShippingService.getShipTime(shipTimeGetRequest);
            if(!Lang.isEmpty(resMap)) {
                ShipTimeGetResponse shipTimeGetResponse = (ShipTimeGetResponse) resMap.get(SnOrderService.RETURN_MAP_KEY_RESULT);
                if(!Lang.isEmpty(shipTimeGetResponse)) {
                    return JSON.toJSONString(shipTimeGetResponse);
                }
            }
        }
        return null;
    }

    @Override
    public String getShipCarriage(String requestJson) {
        if(!Lang.isEmpty(requestJson)) {
            ShipCarriageGetRequest shipCarriageGetRequest = JSON.parseObject(requestJson, ShipCarriageGetRequest.class);
            Map resMap = snShippingService.getShipCarriage(shipCarriageGetRequest);
            if(!Lang.isEmpty(resMap)) {
                ShipCarriageGetResponse shipCarriageGetResponse = (ShipCarriageGetResponse) resMap.get(SnOrderService.RETURN_MAP_KEY_RESULT);
                if(!Lang.isEmpty(shipCarriageGetResponse)) {
                    return JSON.toJSONString(shipCarriageGetResponse);
                }
            }
        }
        return null;
    }


    @Override
    public String commonJsonInvoke(String requestJson, String requestApiName, String requestMethodName, Class requestType) {
        Class apiClz;
        Object serviceInstance = applicationContext.getBean(requestApiName);
        if(serviceInstance != null) {
            apiClz = serviceInstance.getClass();
            try {
                Method invkeMethod = apiClz.getDeclaredMethod(requestMethodName, requestType);
                Object returnObj = invkeMethod.invoke(serviceInstance, new Object[]{JSON.parseObject(requestJson, requestType)});
                if(returnObj instanceof Map) {
                    return JSON.toJSONString(((Map) returnObj).get("result"));
                }
                return JSON.toJSONString(returnObj);
            } catch (NoSuchMethodException e) {
                throw new RuntimeException("Api "+requestApiName+"."+requestMethodName+" invkoe error! api not found !", e);
            } catch (InvocationTargetException e) {
                throw new RuntimeException("Api "+requestApiName+"."+requestMethodName+" invkoe error!", e);
            } catch (IllegalAccessException e) {
                throw new RuntimeException("Api "+requestApiName+"."+requestMethodName+" invkoe error! api not found !", e);
            }
        }

        return null;
    }

    @Override
    public Map addProdBySkus(Map resMap, String skuids, String categoryId, String categoryName, String cmmdtyType) {
        return snProdService.addProdBySkus(resMap,skuids,categoryId,categoryName,cmmdtyType);
    }

    @Override
    public ProviderGoodsDto updateSnGoodsMessageHandel(String sku) {

        return  snMessageService.MessageSnGoodsHandel(sku);
    }
}
