package suning.service.apiImpl.stock;

import com.suning.api.DefaultSuningClient;
import com.suning.api.entity.govbus.InventoryGetRequest;
import com.suning.api.entity.govbus.InventoryGetResponse;
import com.suning.api.entity.govbus.MpStockQueryRequest;
import com.suning.api.entity.govbus.MpStockQueryResponse;
import com.suning.api.exception.SuningApiException;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.springframework.beans.factory.annotation.Autowired;
import suning.api.stock.SnStockApi;
import suning.service.apiImpl.BaseSuNingConfig;
import suning.service.service.SnSystemLogService;
import suning.service.utils.SysHelpUtils;
import utils.log.Log;
import utils.log.Logs;

import java.util.Map;

/**
 * Created by Roney on 2017-04-05.
 */
@MotanService(basicService = "motanServerBasicConfig")
public class SnStockApiImpl extends BaseSuNingConfig implements SnStockApi {
    private final static Log log = Logs.getLog(SnStockApiImpl.class.getName());
    @Autowired
    SnSystemLogService snSystemLogService;
    @Override
    public InventoryGetResponse getInventory(InventoryGetRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey,appSecret, format);
        Map logMap= SysHelpUtils.gennerBaseConfigMap(serverUrl, appKey,appSecret, format);
        try {

            //得到请求结果
            InventoryGetResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);
            log.info("response.getBody(){} :" , response.getBody());

            return  response;
        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public MpStockQueryResponse queryMprodStock(MpStockQueryRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey,appSecret, format);

        try {

            //得到请求结果
            MpStockQueryResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);
            log.info("response.getBody(){} :" , response.getBody());
            return  response;
        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }
}
