package suning.service.config;

import com.weibo.api.motan.filter.opentracing.OpenTracingContext;
import com.weibo.api.motan.filter.opentracing.TracerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author Liang Wenxu
 * @since 2018-05-24
 */
@Configuration
@EnableConfigurationProperties(ZipkinBraveTarcerProperties.class)
public class CommonZipkinAutoConfig {

    ZipkinBraveTarcerProperties zipkinBraveTarcerProperties;

    public CommonZipkinAutoConfig(ZipkinBraveTarcerProperties zipkinBraveTarcerProperties) {
        this.zipkinBraveTarcerProperties = zipkinBraveTarcerProperties;
    }

    // 初始化BraveTarcerFactory
    @Bean
    BraveTarcerFactory tarcerFactory() {
        return new BraveTarcerFactory(zipkinBraveTarcerProperties);
    }

    @Bean
    OpenTracingContext openTracingContext(TracerFactory tracerFactory) {
        OpenTracingContext context = new OpenTracingContext();
        context.setTracerFactory(tracerFactory);
        return context;
    }
}
