package suning.service.controller;

import com.suning.api.entity.govbus.PreDepositBalanceGetRequest;
import com.suning.api.entity.govbus.PreDepositBalanceGetResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import suning.service.service.PreDepositBalanceService;
import utils.GlobalContants;
import utils.log.Log;
import utils.log.Logs;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Roney on 2017-04-09.
 */
@Controller
@RequestMapping("preDepositBalance")
public class PreDepositBalanceController {
    private final static Log log = Logs.getLog(PreDepositBalanceController.class.getName());


    @Value("${suning.api.initPassword}")
    private String password ;

    @Autowired
    PreDepositBalanceService preDepositBalanceService;

    @RequestMapping(value = "get",method = RequestMethod.GET)
    @ResponseBody
    public Map get() {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        PreDepositBalanceGetRequest request = new PreDepositBalanceGetRequest();
        return  preDepositBalanceService.get(request);

    }
}
