package suning.service.controller;

import com.suning.api.entity.govbus.InvoiceConfirmRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import suning.service.service.SnInvoiceService;
import utils.GlobalContants;
import utils.log.Log;
import utils.log.Logs;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Roney on 2017-04-09.
 */
@Controller
@RequestMapping("invoice")
public class SnInvoiceController {
    private final static Log log = Logs.getLog(SnInvoiceController.class.getName());


    @Value("${suning.api.initPassword}")
    private String password ;

    @Autowired
    SnInvoiceService snInvoiceService;

    @RequestMapping(value = "confirm",method = RequestMethod.GET)
    @ResponseBody
    public Map confirm(String password) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        InvoiceConfirmRequest request = new InvoiceConfirmRequest();
        return  snInvoiceService.confirm(request);

    }


}
