package suning.service.controller;

import com.alibaba.fastjson.JSONObject;
import com.suning.api.entity.govbus.PriceQueryRequest;
import com.suning.api.entity.govbus.PriceQueryResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import suning.service.service.SnPriceService;
import utils.GlobalContants;
import utils.Lang;
import utils.data.GzipUtils;
import utils.log.Log;
import utils.log.Logs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Roney on 2017-04-07.
 */
@Controller
@RequestMapping("price")
public class SnPriceController {
    private final static Log log = Logs.getLog(SnPriceController.class.getName());


    @Value("${suning.api.initPassword}")
    private String password ;

    @Autowired
    SnPriceService snPriceService;

    @RequestMapping(value = "queryPrice",method = RequestMethod.GET)
    @ResponseBody
    public Map queryPrice(@RequestParam(name = "skus[]", required = true) String[] skus,String password,String cityId) {
        Map returnMap=new HashMap();
//        if(!StringUtils.equals(this.password,password)){
//            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
//            return returnMap;
//        }
        if(Lang.isEmpty(cityId)){
            cityId="010";
        }
        for(int i=0;i<skus.length;i++) {
            PriceQueryRequest request = new PriceQueryRequest();
            request.setCityId(cityId);
            List<PriceQueryRequest.Skus> skuses = new ArrayList<PriceQueryRequest.Skus>();
            PriceQueryRequest.Skus skuIds = new PriceQueryRequest.Skus();
            skuIds.setSkuId(skus[i]);
            skuses.add(skuIds);
            request.setSkus(skuses);
//api入参校验逻辑开关，当测试稳定之后建议设置为 false 或者删除该行
//        request.setCheckParam(true);
            returnMap.put(skus[i],snPriceService.queryPrice(request));
        }
        return  returnMap;

    }

}
