package suning.service.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.suning.api.entity.govbus.*;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsConfigApi;
import goods.vo.GoodsConfigUpdateMessage;
import jd.api.request.product.PageNumEntity;
import jd.api.request.product.ProductDetailEntity;
import jd.api.vo.product.ProductDetailVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import suning.api.good.SnCategoryApi;
import suning.api.good.SnProductApi;
import suning.service.service.SnProdService;
import utils.GlobalContants;
import utils.Lang;
import utils.excel.ReadExcelUtil;
import utils.file.FileUtils;
import utils.log.Log;
import utils.log.Logs;
import utils.web.ResponseMapUtils;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Roney on 2017-04-07.
 */
@Controller
@RequestMapping("prod")
public class SnProdController {
    private final static Log log = Logs.getLog(SnProdController.class.getName());

    @Autowired
    SnProdService snProdService;

    @Autowired
    SnCategoryApi snCategoryApi;

    @Autowired
    SnProductApi snProductApi;



    @Value("${suning.api.initPassword}")
    private String password ;
    @RequestMapping(value = "initProd",method = RequestMethod.GET)
    @ResponseBody
    public Map initProd(String password) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        Map map = new HashMap();
        snProdService.initProd();
        map.put("msg","商品同步");
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "showCategory",method = RequestMethod.GET)
    public Map showCategory(String password){
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        return snProdService.getCategory();
    }

    @ResponseBody
    @RequestMapping(value = "showProdPool",method = RequestMethod.GET)
    public Map showProdPool(@RequestParam(value="categoryId") String categoryId,String password){
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        return snProdService.getProdPool(categoryId);
    }


    @ResponseBody
    @RequestMapping(value = "showProdDetail",method = RequestMethod.GET)
    public Map showProdDetail(@RequestParam(value="skuids[]") String[] skuids,String password){
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        for(int i=0;i<skuids.length;i++) {
            returnMap.put(skuids[i],snProdService.getProdDetail(skuids[i]));
        }
        return returnMap ;
    }

    @RequestMapping("/downloadSnProductPools")
    @ResponseBody
    public Map downloadSnProductPools(HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        List<Map> writeExcelList = new ArrayList<>();
        CategoryGetRequest categoryReq = new CategoryGetRequest();
        CategoryGetResponse categoryRes = snCategoryApi.getCategory(categoryReq);
        Integer totalBreak=0;
        if (categoryRes.getSnerror()==null) {
            List<CategoryGetResponse.ResultInfo> categoryResult = categoryRes.getSnbody().getGetCategory().getResultInfo();

            for (int i = 0; i < categoryResult.size(); i++) {
                totalBreak++;
                CategoryGetResponse.ResultInfo result=categoryResult.get(i);
                ProdPoolQueryRequest poolReq = new ProdPoolQueryRequest();
                poolReq.setCategoryId(result.getCategoryId());
                poolReq.setCheckParam(true);
                ProdPoolQueryResponse poolRes = snProductApi.queryProdPool(poolReq);
                if(poolRes.getSnerror() == null) {
                    List<ProdPoolQueryResponse.ResultInfo> poolList = poolRes.getSnbody().getQueryProdPool().getResultInfo();
                    for( ProdPoolQueryResponse.ResultInfo poolResult:poolList){
                        Map writeExcelMap = new HashMap();
                        writeExcelMap.put("categoryId", result.getCategoryId());
                        writeExcelMap.put("categoryName", result.getCategoryName());
                        String cmmdtyType = poolResult.getCmmdtyType();//	1	商品类型 1：普通商品 2：套餐商品
                        String generalSku = poolResult.getGeneralSku();//	通码，具有相同通码的sku表示一组类似的商品
                        String skuId = poolResult.getSkuId();//
                        writeExcelMap.put("cmmdtyType", cmmdtyType);
                        writeExcelMap.put("generalSku",generalSku);
                        writeExcelMap.put("skuId", skuId);

//                       if(!Lang.isEmpty(skuId)){
//                           ProdDetailGetRequest detailReq = new ProdDetailGetRequest();
//                           detailReq.setSkuId(skuId);
//                           ProdDetailGetResponse detailRes = snProductApi.getProdDetail(detailReq);
//                           if(!Lang.isEmpty(detailRes)){
//                               String name= detailRes.getSnbody().getGetProdDetail().getName();
//                               writeExcelMap.put("name", name);
//                               writeExcelList.add(writeExcelMap);
//                           }
//                       }
                    }
                }
//                if(totalBreak>=1){
//                    break;
//                }
            }
        }


            // 在webbook中添加一个sheet,对应Excel文件中的sheet
            HSSFSheet sheet = wb.createSheet();
            wb.setSheetName(0, "苏宁商品分类信息");

            Integer indexSize=6;
            List<Map<String,Integer>> mapList=gennetMapList(indexSize);
            ReadExcelUtil.setContentColumnWidth(sheet,mapList);
            HSSFCellStyle cellStyle = ReadExcelUtil.setContentCellStyle(wb);
            List<Map<String,String>> headList=gennetHeadMapList(indexSize);
            ReadExcelUtil.createCellHead(sheet.createRow(0), cellStyle, sheet.createRow(0).createCell(0),headList);
            createCellContent(writeExcelList, cellStyle, sheet);


        // FileUtils.textToFile("e://ss.txt", JSONObject.toJSONString(returnMap));
        // 将文件存到指定位置
        try {
            response.setHeader("Content-disposition", "attachment; filename=" + "SnProduct"+ ".xls");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            wb.write(out);
            out.flush();
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
            log.error("Error", e);
        }
        return null;
    }

    private void createCellContent(List<Map> writeExcelList, HSSFCellStyle cellStyle, HSSFSheet sheet) {
        for (int i = 0; i < writeExcelList.size(); i++) {
            int rowCount = i + 1;
            HSSFRow row = sheet.createRow(rowCount);
            Map returnMap = writeExcelList.get(i);
            HSSFCell theCell = row.createCell(0);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(ReadExcelUtil.setContentCellValue((String) returnMap.get("categoryName")));
            theCell = row.createCell(1);
            theCell.setCellValue(ReadExcelUtil.setContentCellValue((String) returnMap.get("categoryId")));
            theCell = row.createCell(2);
            theCell.setCellValue(ReadExcelUtil.setContentCellValue((String) returnMap.get("cmmdtyType")).equals("1")?"普通商品":"通用商品");
            theCell = row.createCell(3);
            theCell.setCellValue(ReadExcelUtil.setContentCellValue((String) returnMap.get("generalSku")));
            theCell = row.createCell(4);
            theCell.setCellValue(ReadExcelUtil.setContentCellValue((String) returnMap.get("skuId")));
            theCell = row.createCell(5);
            theCell.setCellValue(ReadExcelUtil.setContentCellValue((String) returnMap.get("name")));

        }
    }

    private List<Map<String,String>> gennetHeadMapList(Integer indexSize) {
        List<Map<String, String>> retrunMapList=new ArrayList();

        Map returnMap=new HashMap();
        returnMap.put("index","1");
        returnMap.put("name","商品分类名称");
        retrunMapList.add(returnMap);

        returnMap=new HashMap();
        returnMap.put("index","2");
        returnMap.put("name","商品分类ID");
        retrunMapList.add(returnMap);

        returnMap=new HashMap();
        returnMap.put("index","3");
        returnMap.put("name","商品类型");
        retrunMapList.add(returnMap);

        returnMap=new HashMap();
        returnMap.put("index","4");
        returnMap.put("name","通码(具有相同通码的sku表示一组类似的商品)");
        retrunMapList.add(returnMap);

        returnMap=new HashMap();
        returnMap.put("index","5");
        returnMap.put("name","商品编号");
        retrunMapList.add(returnMap);

        returnMap=new HashMap();
        returnMap.put("index","6");
        returnMap.put("name","商品名称");
        retrunMapList.add(returnMap);

        return retrunMapList;
    }

    private List<Map<String, Integer>> gennetMapList(Integer indexSize) {
        List<Map<String, Integer>> retrunMapList=new ArrayList();
        for(int i=0;i<indexSize;i++){
            Map returnMap=new HashMap();
            returnMap.put("index",i);
            returnMap.put("size",5000);
            retrunMapList.add(returnMap);
        }
        return retrunMapList;
    }

    @ResponseBody
    @RequestMapping(value = "addProdBySkus",method = RequestMethod.GET)
    public Map addProdBySkus(@RequestParam(value="skuids") String skuids,
                             @RequestParam(value="categoryId", required = false)String categoryId,
                             @RequestParam(value="categoryName", required = false)String categoryName,
                             @RequestParam(value="cmmdtyType", required = false)String cmmdtyType,String password){
        Map resMap = null;
        if(!StringUtils.equals(this.password,password)){
            resMap = ResponseMapUtils.error("密码错误", "1");
        } else {
            resMap=snProdService.addProdBySkus(resMap,skuids,categoryId,categoryName,cmmdtyType);

        }
        return resMap;
    }

    @ResponseBody
    @RequestMapping(value = "showProdImage",method = RequestMethod.GET)
    public Map showProdImage(@RequestParam(value="skuid") String skuid,String password){
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        return snProdService.getProdImage(skuid);
    }

    @ResponseBody
    @RequestMapping(value = "showProdReview",method = RequestMethod.GET)
    public Map showProdReview(@RequestParam(value="skuid") String skuid,String password){
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }

        return snProdService.getProdReview(skuid);
    }

    @ResponseBody
    @RequestMapping(value = "deleteAllSnGoods",method = RequestMethod.GET)
    public Map deleteAllSnGoods(String password){
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        snProdService.deleteAllSnGoods();
        returnMap.put("msg","删除苏宁商品");
        return returnMap;
    }


    @ResponseBody
    @RequestMapping(value = "addProdBySkuAndTxt",method = RequestMethod.GET)
    public Map addProdBySkuAndTxt(String password){
        Map returnMap=new HashMap();

        String JsonContext = txt2String(new File("/home/weblogic/applications/product.txt"));
        log.info(JsonContext);
        String skuids=JsonContext;

        return snProdService.addProdBySkus(returnMap,skuids,null,null,null);

    }


    public static String txt2String(File file){
        StringBuilder result = new StringBuilder();
        try{
            BufferedReader br = new BufferedReader(new FileReader(file));//构造一个BufferedReader类来读取文件
            String s = null;
            while((s = br.readLine())!=null){//使用readLine方法，一次读一行
                result.append(System.lineSeparator()+s);
            }
            br.close();
        }catch(Exception e){
            e.printStackTrace();
        }
        return result.toString();
    }


}
