package suning.service.controller;

import com.suning.api.entity.govbus.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import suning.service.service.SnOrderService;
import suning.service.service.SnShippingService;
import utils.GlobalContants;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Roney on 2017-04-07.
 */
@Controller
@RequestMapping("shipping")
public class SnShippingController {
    private final static Log log = Logs.getLog(SnShippingController.class.getName());


    @Value("${suning.api.initPassword}")
    private String password ;

    @Autowired
    SnShippingService snShippingService;

    @Autowired
    SnOrderService snOrderService;

    @RequestMapping(value = "getOrderLogist",method = RequestMethod.GET)
    @ResponseBody
    public Map getOrderLogist(String password, String orderId) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        OrderlogistnewGetRequest request = new OrderlogistnewGetRequest();
        OrderStatusGetRequest orderStatusGetRequest = new OrderStatusGetRequest();
        orderStatusGetRequest.setOrderId(orderId);
        OrderStatusGetResponse orderStatusGetResponse= snOrderService.getOrderStatus(orderStatusGetRequest);

//        OrderStatusGetResponse orderStatusGetResponse =
//                (OrderStatusGetResponse) orderStatusGetResponseMap.get(SnOrderService.RETURN_MAP_KEY_RESULT);

        List<OrderlogistnewGetRequest.OrderItemIds> orderItemListList = new ArrayList<>();
        if(orderStatusGetResponse != null&& Lang.isEmpty(orderStatusGetResponse.getSnerror().getErrorCode())) {
            request.setOrderId(orderId);

            for(OrderStatusGetResponse.OrderItemInfoList oil : orderStatusGetResponse.getSnbody().getGetOrderStatus().getOrderItemInfoList()) {
                OrderlogistnewGetRequest.OrderItemIds oiids = new OrderlogistnewGetRequest.OrderItemIds();
                oiids.setOrderItemId(oil.getOrderItemId());
                oiids.setSkuId(oil.getSkuId());
                orderItemListList.add(oiids);
            }

            request.setOrderItemIds(orderItemListList);
            return snShippingService.getOrderLogistNew(request);
        }else{
            returnMap.put("result",orderStatusGetResponse);
            return returnMap;
        }
    }

    @RequestMapping(value = "getShipTime",method = RequestMethod.GET)
    @ResponseBody
    public Map getShipTime(String password) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        ShipTimeGetRequest request = new ShipTimeGetRequest();
        return snShippingService.getShipTime(request);
    }

    @RequestMapping(value = "getShipCarriage",method = RequestMethod.GET)
    @ResponseBody
    public Map getShipCarriage(String password) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        ShipCarriageGetRequest request = new ShipCarriageGetRequest();
        return snShippingService.getShipCarriage(request);
    }

    @RequestMapping(value = "confirmFacProduct",method = RequestMethod.GET)
    @ResponseBody
    public Map confirmFacProduct(String password) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        FacProductConfirmRequest request = new FacProductConfirmRequest();
        return snShippingService.confirmFacProduct(request);
    }


}
