package suning.service.service;

import com.suning.api.entity.govbus.PriceQueryRequest;
import com.suning.api.entity.govbus.PriceQueryResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import suning.api.price.SnPriceApi;
import suning.service.apiImpl.price.SnPriceApiImpl;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Roney on 2017-04-09.
 */
@Component
public class SnPriceService {
    private final static Log log = Logs.getLog(SnPriceService.class.getName());

    @Autowired
    SnPriceApi snPriceApi;
    public Map queryPrice(PriceQueryRequest request) {
        Map returnMap=new HashMap();
        returnMap.put("result",snPriceApi.queryPrice(request));
        return returnMap;
    }

    public List<Map<String,String>> queryGoodsPrice(List<Map<String,String>> params , String cityId){
        List<Map<String,String>> resultList = new ArrayList<>();
        PriceQueryRequest request = new PriceQueryRequest();
        List<PriceQueryRequest.Skus> skuses = new ArrayList<>();
        request.setCityId(cityId);
        int arraySize = params.size();
        for (int i = 0; i < arraySize; i++){
            PriceQueryRequest.Skus skus = new PriceQueryRequest.Skus();
            skus.setSkuId(params.get(i).get("skuId"));
            skuses.add(skus);
            if(i != 0 && i % 49 == 0 || arraySize-1 == i){
                request.setSkus(skuses);

                log.info("开始调用价格查询接口...");
                long queryPriceTime = System.currentTimeMillis();
                PriceQueryResponse response = snPriceApi.queryPrice(request);
                log.info("调用价格查询接口耗时 {} ms", System.currentTimeMillis() - queryPriceTime);

                if(Lang.isEmpty(response) || response.getSnerror()!=null){
                    return null;
                }
                List<PriceQueryResponse.Skus> resultInfos = response.getSnbody().getQueryPrice().getSkus();
                for (PriceQueryResponse.Skus resultInfo :resultInfos){
                    Map<String,String> map = new HashMap<>();
                    map.put("skuId",resultInfo.getSkuId());
                    map.put("discountRate",resultInfo.getDiscountRate());
                    map.put("price",resultInfo.getPrice());
                    map.put("snPrice",resultInfo.getSnPrice());
                    resultList.add(map);
                }
                skuses.clear();
            }
        }
        return resultList;
    }



}
